"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var resource_exports = {};
__export(resource_exports, {
  ResourceInputSchema: () => ResourceInputSchema,
  ResourceOutputSchema: () => ResourceOutputSchema,
  defineResource: () => defineResource,
  dynamicResource: () => dynamicResource,
  findMatchingResource: () => findMatchingResource,
  isDynamicResourceAction: () => isDynamicResourceAction,
  resource: () => resource
});
module.exports = __toCommonJS(resource_exports);
var import_core = require("@genkit-ai/core");
var import_uri_templates = __toESM(require("uri-templates"));
var import_model_types = require("./model-types.js");
const ResourceInputSchema = import_core.z.object({
  uri: import_core.z.string()
});
const ResourceOutputSchema = import_core.z.object({
  content: import_core.z.array(import_model_types.PartSchema)
});
function defineResource(registry, opts, fn) {
  const action2 = dynamicResource(opts, fn);
  action2.matches = createMatcher(opts.uri, opts.template);
  registry.registerAction("resource", action2);
  return action2;
}
async function findMatchingResource(registry, input) {
  for (const actKeys of Object.keys(await registry.listResolvableActions())) {
    if (actKeys.startsWith("/resource/")) {
      const resource2 = await registry.lookupAction(actKeys);
      if (resource2.matches(input)) {
        return resource2;
      }
    }
  }
  return void 0;
}
function isDynamicResourceAction(t) {
  return (0, import_core.isAction)(t) && !t.__registry;
}
function resource(opts, fn) {
  return dynamicResource(opts, fn);
}
function dynamicResource(opts, fn) {
  const uri = opts.uri ?? opts.template;
  if (!uri) {
    throw new import_core.GenkitError({
      status: "INVALID_ARGUMENT",
      message: `must specify either url or template options`
    });
  }
  const matcher = createMatcher(opts.uri, opts.template);
  const act = (0, import_core.action)(
    {
      actionType: "resource",
      name: opts.name ?? uri,
      description: opts.description,
      inputSchema: ResourceInputSchema,
      outputSchema: ResourceOutputSchema,
      metadata: {
        resource: {
          uri: opts.uri,
          template: opts.template
        },
        ...opts.metadata,
        type: "resource",
        dynamic: true
      }
    },
    async (input, ctx) => {
      const templateMatch = matcher(input);
      if (!templateMatch) {
        throw new import_core.GenkitError({
          status: "INVALID_ARGUMENT",
          message: `input ${input} did not match template ${uri}`
        });
      }
      const parts = await fn(input, ctx);
      parts.content.map((p) => {
        if (!p.metadata) {
          p.metadata = {};
        }
        if (p.metadata?.resource) {
          if (!p.metadata.resource.parent) {
            p.metadata.resource.parent = {
              uri: input.uri
            };
            if (opts.template) {
              p.metadata.resource.parent.template = opts.template;
            }
          }
        } else {
          p.metadata.resource = {
            uri: input.uri
          };
          if (opts.template) {
            p.metadata.resource.template = opts.template;
          }
        }
        return p;
      });
      return parts;
    }
  );
  act.matches = matcher;
  act.attach = (_) => act;
  return act;
}
function createMatcher(uriOpt, templateOpt) {
  if (uriOpt) {
    return (input) => input.uri === uriOpt;
  }
  if (templateOpt) {
    const template = (0, import_uri_templates.default)(templateOpt);
    return (input) => template.fromUri(input.uri) !== void 0;
  }
  throw new import_core.GenkitError({
    status: "INVALID_ARGUMENT",
    message: "must specify either url or template options"
  });
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ResourceInputSchema,
  ResourceOutputSchema,
  defineResource,
  dynamicResource,
  findMatchingResource,
  isDynamicResourceAction,
  resource
});
//# sourceMappingURL=resource.js.map