import { TimedEvent, ReadableSpan } from '@opentelemetry/sdk-trace-base';

/**
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

declare function extractOuterFlowNameFromPath(path: string): string;
declare function truncate(text: string, limit?: number): string;
declare function truncatePath(path: string): string;
/**
 * Extract first feature name from a path
 * e.g. for /{myFlow,t:flow}/{myStep,t:flowStep}/{googleai/gemini-pro,t:action,s:model}
 * returns "myFlow"
 */
declare function extractOuterFeatureNameFromPath(path: string): string;
declare function extractErrorName(events: TimedEvent[]): string | undefined;
declare function extractErrorMessage(events: TimedEvent[]): string | undefined;
declare function extractErrorStack(events: TimedEvent[]): string | undefined;
declare function createCommonLogAttributes(span: ReadableSpan, projectId?: string): {
    'logging.googleapis.com/spanId': string;
    'logging.googleapis.com/trace': string;
    'logging.googleapis.com/trace_sampled': string;
};
declare function requestDenied(err: Error & {
    code?: number;
    statusDetails?: Record<string, any>[];
}): boolean;
declare function loggingDenied(err: Error & {
    code?: number;
    statusDetails?: Record<string, any>[];
}): boolean | undefined;
declare function tracingDenied(err: Error & {
    code?: number;
    statusDetails?: Record<string, any>[];
}): boolean;
declare function metricsDenied(err: Error & {
    code?: number;
    statusDetails?: Record<string, any>[];
}): boolean;
declare function permissionDeniedHelpText(role: string): Promise<string>;
declare function loggingDeniedHelpText(): Promise<string>;
declare function tracingDeniedHelpText(): Promise<string>;
declare function metricsDeniedHelpText(): Promise<string>;

export { createCommonLogAttributes, extractErrorMessage, extractErrorName, extractErrorStack, extractOuterFeatureNameFromPath, extractOuterFlowNameFromPath, loggingDenied, loggingDeniedHelpText, metricsDenied, metricsDeniedHelpText, permissionDeniedHelpText, requestDenied, tracingDenied, tracingDeniedHelpText, truncate, truncatePath };
