"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var embedder_exports = {};
__export(embedder_exports, {
  EmbeddingConfigSchema: () => EmbeddingConfigSchema,
  TEST_ONLY: () => TEST_ONLY,
  defineEmbedder: () => defineEmbedder,
  defineKnownModels: () => defineKnownModels,
  listActions: () => listActions,
  model: () => model
});
module.exports = __toCommonJS(embedder_exports);
var import_genkit = require("genkit");
var import_embedder = require("genkit/embedder");
var import_client = require("./client.js");
var import_types = require("./types.js");
var import_utils = require("./utils.js");
const EmbeddingConfigSchema = import_genkit.z.object({
  /** Override the API key provided at plugin initialization. */
  apiKey: import_genkit.z.string().optional(),
  /**
   * The `task_type` parameter is defined as the intended downstream application to help the model
   * produce better quality embeddings.
   **/
  taskType: import_types.TaskTypeSchema.optional(),
  title: import_genkit.z.string().optional(),
  version: import_genkit.z.string().optional(),
  /**
   * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
   * By default, the model generates embeddings with 768 dimensions. Models such as
   * `text-embedding-004`, `text-embedding-005`, and `text-multilingual-embedding-002`
   * allow the output dimensionality to be adjusted between 1 and 768.
   * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
   **/
  outputDimensionality: import_genkit.z.number().min(1).optional()
}).passthrough();
function commonRef(name, info, configSchema = EmbeddingConfigSchema) {
  return (0, import_embedder.embedderRef)({
    name: `googleai/${name}`,
    configSchema,
    info: info ?? {
      dimensions: 768,
      supports: {
        input: ["text"]
      }
    }
  });
}
const GENERIC_MODEL = commonRef("embedder");
const KNOWN_MODELS = {
  "text-embedding-004": commonRef("text-embedding-004"),
  "gemini-embedding-001": commonRef("gemini-embedding-001")
};
function model(version, config = {}) {
  const name = (0, import_utils.checkModelName)(version);
  return (0, import_embedder.embedderRef)({
    name: `googleai/${name}`,
    config,
    configSchema: GENERIC_MODEL.configSchema,
    info: {
      ...GENERIC_MODEL.info
    }
  });
}
function listActions(models) {
  return models.filter((m) => m.supportedGenerationMethods.includes("embedContent")).filter((m) => !m.description || !m.description.includes("deprecated")).map((m) => {
    const ref = model(m.name);
    return (0, import_genkit.embedderActionMetadata)({
      name: ref.name,
      info: ref.info,
      configSchema: ref.configSchema
    });
  });
}
function defineKnownModels(ai, options) {
  for (const name of Object.keys(KNOWN_MODELS)) {
    defineEmbedder(ai, name, options);
  }
}
function defineEmbedder(ai, name, pluginOptions) {
  (0, import_utils.checkApiKey)(pluginOptions?.apiKey);
  const ref = model(name);
  return ai.defineEmbedder(
    {
      name: ref.name,
      configSchema: ref.configSchema,
      info: ref.info
    },
    async (input, reqOptions) => {
      const embedApiKey = (0, import_utils.calculateApiKey)(
        pluginOptions?.apiKey,
        reqOptions?.apiKey
      );
      const embedVersion = reqOptions?.version || (0, import_utils.extractVersion)(ref);
      const embeddings = await Promise.all(
        input.map(async (doc) => {
          const response = await (0, import_client.embedContent)(embedApiKey, embedVersion, {
            taskType: reqOptions?.taskType,
            title: reqOptions?.title,
            content: {
              role: "",
              parts: [{ text: doc.text }]
            },
            outputDimensionality: reqOptions?.outputDimensionality
          });
          const values = response.embedding.values;
          return { embedding: values };
        })
      );
      return { embeddings };
    }
  );
}
const TEST_ONLY = { KNOWN_MODELS };
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  EmbeddingConfigSchema,
  TEST_ONLY,
  defineEmbedder,
  defineKnownModels,
  listActions,
  model
});
//# sourceMappingURL=embedder.js.map