"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.gemini = void 0;
const utils_1 = require("@genkit-ai/tools-common/utils");
const fs_1 = require("fs");
const promises_1 = require("fs/promises");
const path = __importStar(require("path"));
const utils_2 = require("../utils");
const GEMINI_DIR = '.gemini';
const GEMINI_SETTINGS_PATH = path.join(GEMINI_DIR, 'settings.json');
const GENKIT_MD_SYMLINK_PATH = path.join(GEMINI_DIR, utils_2.GENKIT_PROMPT_PATH);
const GENKIT_MCP_CONFIG = {
    command: 'genkit',
    args: ['mcp', '--no-update-notification'],
    cwd: '.',
    timeout: 30000,
    trust: false,
    excludeTools: [
        'run_shell_command(genkit start)',
        'run_shell_command(npx genkit start)',
    ],
};
exports.gemini = {
    name: 'gemini',
    displayName: 'Gemini CLI',
    async configure(runtime, options) {
        utils_1.logger.info('Installing as part of GEMINI.md');
        return await installInMdFile(runtime);
    },
};
async function installInMdFile(runtime) {
    const files = [];
    utils_1.logger.info('Installing the Genkit MCP server for Gemini CLI');
    let existingConfig = {};
    let settingsUpdated = false;
    try {
        const fileExists = (0, fs_1.existsSync)(GEMINI_SETTINGS_PATH);
        if (fileExists) {
            existingConfig = JSON.parse((0, fs_1.readFileSync)(GEMINI_SETTINGS_PATH, 'utf-8'));
        }
        else {
            await (0, promises_1.mkdir)(GEMINI_DIR, { recursive: true });
        }
    }
    catch (e) {
    }
    if (!existingConfig.mcpServers?.genkit) {
        if (!existingConfig.mcpServers) {
            existingConfig.mcpServers = {};
        }
        existingConfig.mcpServers.genkit = GENKIT_MCP_CONFIG;
        if (existingConfig.contextFileName) {
            const contextFiles = Array.isArray(existingConfig.contextFileName)
                ? [...existingConfig.contextFileName]
                : [existingConfig.contextFileName];
            if (!contextFiles.includes('GENKIT.md')) {
                contextFiles.push('GENKIT.md');
            }
            existingConfig.contextFileName = contextFiles;
        }
        else {
            existingConfig.contextFileName = 'GENKIT.md';
        }
        await (0, promises_1.writeFile)(GEMINI_SETTINGS_PATH, JSON.stringify(existingConfig, null, 2));
        settingsUpdated = true;
    }
    files.push({ path: GEMINI_SETTINGS_PATH, updated: settingsUpdated });
    utils_1.logger.info('Copying the GENKIT.md file...');
    const baseResult = await (0, utils_2.initGenkitFile)(runtime);
    files.push({ path: utils_2.GENKIT_PROMPT_PATH, updated: baseResult.updated });
    const linkResult = await createGenkitMdLink();
    files.push(linkResult);
    return { files };
}
async function createGenkitMdLink() {
    const sourcePath = utils_2.GENKIT_PROMPT_PATH;
    const targetPath = GENKIT_MD_SYMLINK_PATH;
    const isWindows = process.platform === 'win32';
    if (isWindows) {
        utils_1.logger.info('Copying GENKIT.md to .gemini folder (Windows compatibility mode)');
        try {
            const stats = await (0, promises_1.lstat)(targetPath);
            if (stats.isFile()) {
                utils_1.logger.info('GENKIT.md copy already exists in .gemini folder');
                return { path: targetPath, updated: false };
            }
        }
        catch (error) {
            if (error.code !== 'ENOENT') {
                utils_1.logger.error('Error checking GENKIT.md copy:', error);
                throw error;
            }
        }
        try {
            await (0, promises_1.copyFile)(sourcePath, targetPath);
            utils_1.logger.info('Successfully copied GENKIT.md to .gemini folder');
            return { path: targetPath, updated: true };
        }
        catch (error) {
            utils_1.logger.error('Error copying GENKIT.md:', error);
            throw error;
        }
    }
    else {
        utils_1.logger.info('Adding a symlink for GENKIT.md in the .gemini folder');
        try {
            const stats = await (0, promises_1.lstat)(targetPath);
            if (stats.isSymbolicLink()) {
                const linkTarget = await (0, promises_1.readlink)(targetPath);
                const resolvedLinkTarget = path.resolve(path.dirname(targetPath), linkTarget);
                const resolvedSourcePath = path.resolve(sourcePath);
                if (resolvedLinkTarget === resolvedSourcePath) {
                    utils_1.logger.info('Symlink already exists and points to the correct location');
                    return { path: targetPath, updated: false };
                }
                else {
                    utils_1.logger.warn(`Symlink exists but points to wrong location. Expected: ${resolvedSourcePath}, Found: ${resolvedLinkTarget}. Please remove this file and try again if this was not intentional.`);
                    return { path: targetPath, updated: false };
                }
            }
            else {
                utils_1.logger.warn(`${targetPath} exists but is not a symlink, skipping symlink creation`);
                return { path: targetPath, updated: false };
            }
        }
        catch (error) {
            if (error.code === 'ENOENT') {
                await (0, promises_1.symlink)(path.relative(GEMINI_DIR, sourcePath), targetPath);
                utils_1.logger.info('Successfully created symlink for GENKIT.md');
                return { path: targetPath, updated: true };
            }
            else {
                utils_1.logger.error('Error checking symlink:', error);
                throw error;
            }
        }
    }
}
//# sourceMappingURL=gemini.js.map