import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card";
import { CheckCircle } from "lucide-react";

export default function AboutPage() {
  return (
    <div className="bg-background">
      <header className="bg-primary text-primary-foreground py-16">
        <div className="container text-center">
          <h1 className="font-headline text-4xl md:text-5xl font-bold">About PharmaConnect</h1>
          <p className="mt-4 text-lg max-w-3xl mx-auto text-primary-foreground/80">
            Connecting the Pharmaceutical Ecosystem for a Healthier Tomorrow.
          </p>
        </div>
      </header>

      <section className="py-16 container">
        <div className="grid md:grid-cols-2 gap-12 items-center">
          <div>
            <h2 className="font-headline text-3xl font-bold text-primary">Our Mission</h2>
            <p className="mt-4 text-lg text-muted-foreground">
              Our mission is to create a unified digital platform that empowers every stakeholder in the pharmaceutical industry—from manufacturers and distributors to healthcare professionals and patients. We aim to enhance efficiency, transparency, and accessibility throughout the pharma supply chain.
            </p>
            <h3 className="font-headline text-2xl font-bold text-primary mt-8">Our Vision</h3>
            <p className="mt-4 text-lg text-muted-foreground">
              To be the leading digital backbone of the global pharmaceutical industry, fostering innovation, collaboration, and growth for all our partners and users.
            </p>
          </div>
          <div>
            <Card className="shadow-lg">
                <CardHeader>
                    <CardTitle className="font-headline">What We Do</CardTitle>
                </CardHeader>
                <CardContent>
                    <ul className="space-y-4 text-muted-foreground">
                        <li className="flex items-start">
                            <CheckCircle className="h-5 w-5 mr-3 mt-1 text-accent flex-shrink-0" />
                            <span><strong className="text-foreground">Connect Distributors:</strong> Easily find and connect with trusted medicine distributors in any city.</span>
                        </li>
                        <li className="flex items-start">
                            <CheckCircle className="h-5 w-5 mr-3 mt-1 text-accent flex-shrink-0" />
                            <span><strong className="text-foreground">Facilitate Careers:</strong> Provide a dedicated job board for pharmaceutical professionals and employers.</span>
                        </li>
                         <li className="flex items-start">
                            <CheckCircle className="h-5 w-5 mr-3 mt-1 text-accent flex-shrink-0" />
                            <span><strong className="text-foreground">Simplify Compliance:</strong> Offer expert assistance for GST, drug, and food license applications and renewals.</span>
                        </li>
                         <li className="flex items-start">
                            <CheckCircle className="h-5 w-5 mr-3 mt-1 text-accent flex-shrink-0" />
                            <span><strong className="text-foreground">Support Businesses:</strong> Deliver a suite of services designed to support and grow pharmaceutical businesses of all sizes.</span>
                        </li>
                    </ul>
                </CardContent>
            </Card>
          </div>
        </div>
      </section>
    </div>
  );
}
