import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card";

export default function DistributorsPage() {
  return (
    <div className="bg-background">
      <header className="bg-primary text-primary-foreground py-16">
        <div className="container text-center">
          <h1 className="font-headline text-4xl md:text-5xl font-bold">Find Distributors</h1>
          <p className="mt-4 text-lg max-w-3xl mx-auto text-primary-foreground/80">
            Connect with trusted medicine distributors in your selected city.
          </p>
        </div>
      </header>
      <div className="container py-12">
        <Card className="text-center">
            <CardHeader>
                <CardTitle>Search Results</CardTitle>
                <CardDescription>Distributors based on your search criteria will appear here.</CardDescription>
            </CardHeader>
            <CardContent>
                <p className="text-muted-foreground">No distributors found in the selected city. Please try another location.</p>
            </CardContent>
        </Card>
      </div>
    </div>
  );
}
