import { Button } from "@/components/ui/button";
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card";
import { Input } from "@/components/ui/input";
import { Label } from "@/components/ui/label";
import { Select, SelectContent, SelectItem, SelectTrigger, SelectValue } from "@/components/ui/select";
import { Textarea } from "@/components/ui/textarea";
import { jobDesignations, experienceLevels, cities } from "@/lib/data";

export default function PostJobPage() {
  return (
    <div className="bg-background">
       <header className="bg-primary text-primary-foreground py-16">
        <div className="container text-center">
          <h1 className="font-headline text-4xl md:text-5xl font-bold">Post a Job</h1>
          <p className="mt-4 text-lg max-w-3xl mx-auto text-primary-foreground/80">
            Reach thousands of qualified pharmaceutical professionals.
          </p>
        </div>
      </header>
       <div className="container py-12">
        <Card className="max-w-3xl mx-auto shadow-lg">
            <CardHeader>
                <CardTitle className="font-headline text-2xl">Job Details</CardTitle>
                <CardDescription>Please provide the details for the job opening.</CardDescription>
            </CardHeader>
            <CardContent>
                <form className="space-y-6">
                    <div className="space-y-2">
                        <Label htmlFor="job-title">Job Title</Label>
                        <Input id="job-title" placeholder="e.g., Medical Representative" />
                    </div>
                     <div className="space-y-2">
                        <Label htmlFor="company-name">Company Name</Label>
                        <Input id="company-name" placeholder="Your Company Inc." />
                    </div>
                    <div className="grid grid-cols-1 md:grid-cols-3 gap-4">
                        <div className="space-y-2">
                            <Label htmlFor="designation">Designation</Label>
                             <Select>
                                <SelectTrigger id="designation"><SelectValue placeholder="Select Designation" /></SelectTrigger>
                                <SelectContent>{jobDesignations.map(d => <SelectItem key={d} value={d.toLowerCase()}>{d}</SelectItem>)}</SelectContent>
                            </Select>
                        </div>
                        <div className="space-y-2">
                            <Label htmlFor="experience">Experience Level</Label>
                             <Select>
                                <SelectTrigger id="experience"><SelectValue placeholder="Select Experience" /></SelectTrigger>
                                <SelectContent>{experienceLevels.map(e => <SelectItem key={e} value={e.toLowerCase()}>{e}</SelectItem>)}</SelectContent>
                            </Select>
                        </div>
                        <div className="space-y-2">
                            <Label htmlFor="location">Location</Label>
                             <Select>
                                <SelectTrigger id="location"><SelectValue placeholder="Select Location" /></SelectTrigger>
                                <SelectContent>{cities.map(c => <SelectItem key={c} value={c.toLowerCase()}>{c}</SelectItem>)}</SelectContent>
                            </Select>
                        </div>
                    </div>
                    <div className="space-y-2">
                        <Label htmlFor="job-description">Job Description</Label>
                        <Textarea id="job-description" placeholder="Describe the responsibilities, requirements, and benefits..." rows={8} />
                    </div>
                    <Button type="submit" size="lg" className="w-full md:w-auto">Post Job Opening</Button>
                </form>
            </CardContent>
        </Card>
       </div>
    </div>
  );
}
