import { Button } from "@/components/ui/button";
import Link from "next/link";

export function AboutPreviewSection() {
  return (
    <section className="py-16 md:py-24 bg-primary text-primary-foreground">
      <div className="container text-center">
        <h2 className="font-headline text-3xl md:text-4xl font-bold">About PharmaConnect</h2>
        <div className="max-w-3xl mx-auto mt-4 text-lg text-primary-foreground/80 space-y-4">
            <p>
            PharmaConnect is a one-stop B2B and B2C platform connecting the entire pharmaceutical ecosystem. We bridge the gap between professionals, businesses, and individuals, fostering a seamless network for growth and collaboration.
            </p>
            <p>
            Our mission is to empower every stakeholder in the pharma industry with the tools and connections they need to succeed.
            </p>
        </div>
        <Button variant="secondary" size="lg" className="mt-8" asChild>
          <Link href="/about">Learn More About Us</Link>
        </Button>
      </div>
    </section>
  );
}
