import { Button } from "@/components/ui/button";
import { Card, CardContent, CardHeader, CardTitle, CardDescription } from "@/components/ui/card";
import { Select, SelectContent, SelectItem, SelectTrigger, SelectValue } from "@/components/ui/select";
import { jobDesignations, experienceLevels, cities } from "@/lib/data";
import { Briefcase, UserSearch, FilePlus2 } from "lucide-react";
import Link from "next/link";

export function JobSearchSection() {
  return (
    <section className="py-16 md:py-24 bg-background">
      <div className="container">
        <div className="grid grid-cols-1 lg:grid-cols-3 gap-8 items-center">
          <div className="lg:col-span-2 grid grid-cols-1 md:grid-cols-2 gap-8">
            <Card className="shadow-lg">
              <CardHeader>
                <CardTitle className="flex items-center gap-2 font-headline">
                  <Briefcase className="h-6 w-6 text-accent" />
                  Find A Job
                </CardTitle>
                <CardDescription>Search for your next career opportunity in the pharma industry.</CardDescription>
              </CardHeader>
              <CardContent className="space-y-4">
                <Select>
                  <SelectTrigger><SelectValue placeholder="Designation" /></SelectTrigger>
                  <SelectContent>{jobDesignations.map(d => <SelectItem key={d} value={d.toLowerCase()}>{d}</SelectItem>)}</SelectContent>
                </Select>
                <Select>
                  <SelectTrigger><SelectValue placeholder="Experience" /></SelectTrigger>
                  <SelectContent>{experienceLevels.map(e => <SelectItem key={e} value={e.toLowerCase()}>{e}</SelectItem>)}</SelectContent>
                </Select>
                <Select>
                  <SelectTrigger><SelectValue placeholder="Location" /></SelectTrigger>
                  <SelectContent>{cities.map(c => <SelectItem key={c} value={c.toLowerCase()}>{c}</SelectItem>)}</SelectContent>
                </Select>
                <Button className="w-full" variant="outline" asChild>
                    <Link href="/jobs">Search Job</Link>
                </Button>
              </CardContent>
            </Card>
            <Card className="shadow-lg">
              <CardHeader>
                <CardTitle className="flex items-center gap-2 font-headline">
                  <UserSearch className="h-6 w-6 text-accent" />
                  Find Candidates
                </CardTitle>
                <CardDescription>Discover the best talent for your organization.</CardDescription>
              </CardHeader>
              <CardContent className="space-y-4">
                 <Select>
                  <SelectTrigger><SelectValue placeholder="Designation" /></SelectTrigger>
                  <SelectContent>{jobDesignations.map(d => <SelectItem key={d} value={d.toLowerCase()}>{d}</SelectItem>)}</SelectContent>
                </Select>
                <Select>
                  <SelectTrigger><SelectValue placeholder="Experience" /></SelectTrigger>
                  <SelectContent>{experienceLevels.map(e => <SelectItem key={e} value={e.toLowerCase()}>{e}</SelectItem>)}</SelectContent>
                </Select>
                <Select>
                  <SelectTrigger><SelectValue placeholder="Location" /></SelectTrigger>
                  <SelectContent>{cities.map(c => <SelectItem key={c} value={c.toLowerCase()}>{c}</SelectItem>)}</SelectContent>
                </Select>
                <Button className="w-full" variant="outline" asChild>
                    <Link href="/candidates">Search Candidates</Link>
                </Button>
              </CardContent>
            </Card>
          </div>
          <div className="text-center lg:text-left">
            <h2 className="font-headline text-3xl font-bold text-primary">Join the Network</h2>
            <p className="mt-2 text-muted-foreground">Employers, post your job openings and reach thousands of qualified professionals.</p>
            <Button size="lg" className="mt-6" asChild>
              <Link href="/post-job">
                <FilePlus2 className="mr-2 h-5 w-5" />
                Post a Job
              </Link>
            </Button>
          </div>
        </div>
      </div>
    </section>
  );
}
