import { services } from "@/lib/data";
import { Card, CardHeader, CardTitle, CardDescription, CardFooter } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import Link from "next/link";
import { ArrowRight } from "lucide-react";
import { cn } from "@/lib/utils";

interface ServicesSectionProps {
  title: string;
  description: string;
  className?: string;
}

export function ServicesSection({ title, description, className }: ServicesSectionProps) {
  return (
    <section className={cn("py-16 md:py-24", className)}>
      <div className="container">
        <div className="text-center max-w-3xl mx-auto">
          <h2 className="font-headline text-3xl md:text-4xl font-bold text-primary">
            {title}
          </h2>
          <p className="mt-4 text-lg text-muted-foreground">
            {description}
          </p>
        </div>
        <div className="mt-12 grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-5 gap-6">
          {services.map((service) => (
            <Card key={service.slug} className="flex flex-col text-center items-center group hover:border-primary transition-all shadow-md hover:shadow-xl">
              <CardHeader className="items-center">
                <div className="p-4 bg-secondary rounded-full group-hover:bg-primary transition-colors">
                  <service.icon className="h-8 w-8 text-primary group-hover:text-primary-foreground transition-colors" />
                </div>
                <CardTitle className="font-headline text-md font-bold pt-2">{service.title}</CardTitle>
              </CardHeader>
              <CardFooter className="mt-auto w-full">
                <Button variant="outline" className="w-full group-hover:bg-accent group-hover:text-accent-foreground" asChild>
                  <Link href={`/services/${service.slug}`}>
                    Apply Now <ArrowRight className="ml-2 h-4 w-4" />
                  </Link>
                </Button>
              </CardFooter>
            </Card>
          ))}
        </div>
      </div>
    </section>
  );
}
