import { z, EmbedderReference, ActionMetadata, Genkit, EmbedderAction } from 'genkit';
import { Model, GoogleAIPluginOptions } from './types.mjs';
import '../common/types.mjs';

/**
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

declare const EmbeddingConfigSchema: z.ZodObject<{
    /** Override the API key provided at plugin initialization. */
    apiKey: z.ZodOptional<z.ZodString>;
    /**
     * The `task_type` parameter is defined as the intended downstream application to help the model
     * produce better quality embeddings.
     **/
    taskType: z.ZodOptional<z.ZodEnum<["RETRIEVAL_DOCUMENT", "RETRIEVAL_QUERY", "SEMANTIC_SIMILARITY", "CLASSIFICATION", "CLUSTERING"]>>;
    title: z.ZodOptional<z.ZodString>;
    version: z.ZodOptional<z.ZodString>;
    /**
     * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
     * By default, the model generates embeddings with 768 dimensions. Models such as
     * `text-embedding-004`, `text-embedding-005`, and `text-multilingual-embedding-002`
     * allow the output dimensionality to be adjusted between 1 and 768.
     * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
     **/
    outputDimensionality: z.ZodOptional<z.ZodNumber>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    /** Override the API key provided at plugin initialization. */
    apiKey: z.ZodOptional<z.ZodString>;
    /**
     * The `task_type` parameter is defined as the intended downstream application to help the model
     * produce better quality embeddings.
     **/
    taskType: z.ZodOptional<z.ZodEnum<["RETRIEVAL_DOCUMENT", "RETRIEVAL_QUERY", "SEMANTIC_SIMILARITY", "CLASSIFICATION", "CLUSTERING"]>>;
    title: z.ZodOptional<z.ZodString>;
    version: z.ZodOptional<z.ZodString>;
    /**
     * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
     * By default, the model generates embeddings with 768 dimensions. Models such as
     * `text-embedding-004`, `text-embedding-005`, and `text-multilingual-embedding-002`
     * allow the output dimensionality to be adjusted between 1 and 768.
     * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
     **/
    outputDimensionality: z.ZodOptional<z.ZodNumber>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    /** Override the API key provided at plugin initialization. */
    apiKey: z.ZodOptional<z.ZodString>;
    /**
     * The `task_type` parameter is defined as the intended downstream application to help the model
     * produce better quality embeddings.
     **/
    taskType: z.ZodOptional<z.ZodEnum<["RETRIEVAL_DOCUMENT", "RETRIEVAL_QUERY", "SEMANTIC_SIMILARITY", "CLASSIFICATION", "CLUSTERING"]>>;
    title: z.ZodOptional<z.ZodString>;
    version: z.ZodOptional<z.ZodString>;
    /**
     * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
     * By default, the model generates embeddings with 768 dimensions. Models such as
     * `text-embedding-004`, `text-embedding-005`, and `text-multilingual-embedding-002`
     * allow the output dimensionality to be adjusted between 1 and 768.
     * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
     **/
    outputDimensionality: z.ZodOptional<z.ZodNumber>;
}, z.ZodTypeAny, "passthrough">>;
type EmbeddingConfigSchemaType = typeof EmbeddingConfigSchema;
type EmbeddingConfig = z.infer<EmbeddingConfigSchemaType>;
type ConfigSchemaType = EmbeddingConfigSchemaType;
declare const KNOWN_MODELS: {
    'text-embedding-004': EmbedderReference<z.ZodObject<{
        /** Override the API key provided at plugin initialization. */
        apiKey: z.ZodOptional<z.ZodString>;
        /**
         * The `task_type` parameter is defined as the intended downstream application to help the model
         * produce better quality embeddings.
         **/
        taskType: z.ZodOptional<z.ZodEnum<["RETRIEVAL_DOCUMENT", "RETRIEVAL_QUERY", "SEMANTIC_SIMILARITY", "CLASSIFICATION", "CLUSTERING"]>>;
        title: z.ZodOptional<z.ZodString>;
        version: z.ZodOptional<z.ZodString>;
        /**
         * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
         * By default, the model generates embeddings with 768 dimensions. Models such as
         * `text-embedding-004`, `text-embedding-005`, and `text-multilingual-embedding-002`
         * allow the output dimensionality to be adjusted between 1 and 768.
         * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
         **/
        outputDimensionality: z.ZodOptional<z.ZodNumber>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /** Override the API key provided at plugin initialization. */
        apiKey: z.ZodOptional<z.ZodString>;
        /**
         * The `task_type` parameter is defined as the intended downstream application to help the model
         * produce better quality embeddings.
         **/
        taskType: z.ZodOptional<z.ZodEnum<["RETRIEVAL_DOCUMENT", "RETRIEVAL_QUERY", "SEMANTIC_SIMILARITY", "CLASSIFICATION", "CLUSTERING"]>>;
        title: z.ZodOptional<z.ZodString>;
        version: z.ZodOptional<z.ZodString>;
        /**
         * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
         * By default, the model generates embeddings with 768 dimensions. Models such as
         * `text-embedding-004`, `text-embedding-005`, and `text-multilingual-embedding-002`
         * allow the output dimensionality to be adjusted between 1 and 768.
         * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
         **/
        outputDimensionality: z.ZodOptional<z.ZodNumber>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /** Override the API key provided at plugin initialization. */
        apiKey: z.ZodOptional<z.ZodString>;
        /**
         * The `task_type` parameter is defined as the intended downstream application to help the model
         * produce better quality embeddings.
         **/
        taskType: z.ZodOptional<z.ZodEnum<["RETRIEVAL_DOCUMENT", "RETRIEVAL_QUERY", "SEMANTIC_SIMILARITY", "CLASSIFICATION", "CLUSTERING"]>>;
        title: z.ZodOptional<z.ZodString>;
        version: z.ZodOptional<z.ZodString>;
        /**
         * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
         * By default, the model generates embeddings with 768 dimensions. Models such as
         * `text-embedding-004`, `text-embedding-005`, and `text-multilingual-embedding-002`
         * allow the output dimensionality to be adjusted between 1 and 768.
         * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
         **/
        outputDimensionality: z.ZodOptional<z.ZodNumber>;
    }, z.ZodTypeAny, "passthrough">>>;
    'gemini-embedding-001': EmbedderReference<z.ZodObject<{
        /** Override the API key provided at plugin initialization. */
        apiKey: z.ZodOptional<z.ZodString>;
        /**
         * The `task_type` parameter is defined as the intended downstream application to help the model
         * produce better quality embeddings.
         **/
        taskType: z.ZodOptional<z.ZodEnum<["RETRIEVAL_DOCUMENT", "RETRIEVAL_QUERY", "SEMANTIC_SIMILARITY", "CLASSIFICATION", "CLUSTERING"]>>;
        title: z.ZodOptional<z.ZodString>;
        version: z.ZodOptional<z.ZodString>;
        /**
         * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
         * By default, the model generates embeddings with 768 dimensions. Models such as
         * `text-embedding-004`, `text-embedding-005`, and `text-multilingual-embedding-002`
         * allow the output dimensionality to be adjusted between 1 and 768.
         * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
         **/
        outputDimensionality: z.ZodOptional<z.ZodNumber>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /** Override the API key provided at plugin initialization. */
        apiKey: z.ZodOptional<z.ZodString>;
        /**
         * The `task_type` parameter is defined as the intended downstream application to help the model
         * produce better quality embeddings.
         **/
        taskType: z.ZodOptional<z.ZodEnum<["RETRIEVAL_DOCUMENT", "RETRIEVAL_QUERY", "SEMANTIC_SIMILARITY", "CLASSIFICATION", "CLUSTERING"]>>;
        title: z.ZodOptional<z.ZodString>;
        version: z.ZodOptional<z.ZodString>;
        /**
         * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
         * By default, the model generates embeddings with 768 dimensions. Models such as
         * `text-embedding-004`, `text-embedding-005`, and `text-multilingual-embedding-002`
         * allow the output dimensionality to be adjusted between 1 and 768.
         * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
         **/
        outputDimensionality: z.ZodOptional<z.ZodNumber>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /** Override the API key provided at plugin initialization. */
        apiKey: z.ZodOptional<z.ZodString>;
        /**
         * The `task_type` parameter is defined as the intended downstream application to help the model
         * produce better quality embeddings.
         **/
        taskType: z.ZodOptional<z.ZodEnum<["RETRIEVAL_DOCUMENT", "RETRIEVAL_QUERY", "SEMANTIC_SIMILARITY", "CLASSIFICATION", "CLUSTERING"]>>;
        title: z.ZodOptional<z.ZodString>;
        version: z.ZodOptional<z.ZodString>;
        /**
         * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
         * By default, the model generates embeddings with 768 dimensions. Models such as
         * `text-embedding-004`, `text-embedding-005`, and `text-multilingual-embedding-002`
         * allow the output dimensionality to be adjusted between 1 and 768.
         * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
         **/
        outputDimensionality: z.ZodOptional<z.ZodNumber>;
    }, z.ZodTypeAny, "passthrough">>>;
};
type KnownModels = keyof typeof KNOWN_MODELS;
declare function model(version: string, config?: EmbeddingConfig): EmbedderReference<ConfigSchemaType>;
declare function listActions(models: Model[]): ActionMetadata[];
declare function defineKnownModels(ai: Genkit, options?: GoogleAIPluginOptions): void;
declare function defineEmbedder(ai: Genkit, name: string, pluginOptions?: GoogleAIPluginOptions): EmbedderAction;
declare const TEST_ONLY: {
    KNOWN_MODELS: {
        'text-embedding-004': EmbedderReference<z.ZodObject<{
            /** Override the API key provided at plugin initialization. */
            apiKey: z.ZodOptional<z.ZodString>;
            /**
             * The `task_type` parameter is defined as the intended downstream application to help the model
             * produce better quality embeddings.
             **/
            taskType: z.ZodOptional<z.ZodEnum<["RETRIEVAL_DOCUMENT", "RETRIEVAL_QUERY", "SEMANTIC_SIMILARITY", "CLASSIFICATION", "CLUSTERING"]>>;
            title: z.ZodOptional<z.ZodString>;
            version: z.ZodOptional<z.ZodString>;
            /**
             * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
             * By default, the model generates embeddings with 768 dimensions. Models such as
             * `text-embedding-004`, `text-embedding-005`, and `text-multilingual-embedding-002`
             * allow the output dimensionality to be adjusted between 1 and 768.
             * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
             **/
            outputDimensionality: z.ZodOptional<z.ZodNumber>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /** Override the API key provided at plugin initialization. */
            apiKey: z.ZodOptional<z.ZodString>;
            /**
             * The `task_type` parameter is defined as the intended downstream application to help the model
             * produce better quality embeddings.
             **/
            taskType: z.ZodOptional<z.ZodEnum<["RETRIEVAL_DOCUMENT", "RETRIEVAL_QUERY", "SEMANTIC_SIMILARITY", "CLASSIFICATION", "CLUSTERING"]>>;
            title: z.ZodOptional<z.ZodString>;
            version: z.ZodOptional<z.ZodString>;
            /**
             * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
             * By default, the model generates embeddings with 768 dimensions. Models such as
             * `text-embedding-004`, `text-embedding-005`, and `text-multilingual-embedding-002`
             * allow the output dimensionality to be adjusted between 1 and 768.
             * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
             **/
            outputDimensionality: z.ZodOptional<z.ZodNumber>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /** Override the API key provided at plugin initialization. */
            apiKey: z.ZodOptional<z.ZodString>;
            /**
             * The `task_type` parameter is defined as the intended downstream application to help the model
             * produce better quality embeddings.
             **/
            taskType: z.ZodOptional<z.ZodEnum<["RETRIEVAL_DOCUMENT", "RETRIEVAL_QUERY", "SEMANTIC_SIMILARITY", "CLASSIFICATION", "CLUSTERING"]>>;
            title: z.ZodOptional<z.ZodString>;
            version: z.ZodOptional<z.ZodString>;
            /**
             * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
             * By default, the model generates embeddings with 768 dimensions. Models such as
             * `text-embedding-004`, `text-embedding-005`, and `text-multilingual-embedding-002`
             * allow the output dimensionality to be adjusted between 1 and 768.
             * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
             **/
            outputDimensionality: z.ZodOptional<z.ZodNumber>;
        }, z.ZodTypeAny, "passthrough">>>;
        'gemini-embedding-001': EmbedderReference<z.ZodObject<{
            /** Override the API key provided at plugin initialization. */
            apiKey: z.ZodOptional<z.ZodString>;
            /**
             * The `task_type` parameter is defined as the intended downstream application to help the model
             * produce better quality embeddings.
             **/
            taskType: z.ZodOptional<z.ZodEnum<["RETRIEVAL_DOCUMENT", "RETRIEVAL_QUERY", "SEMANTIC_SIMILARITY", "CLASSIFICATION", "CLUSTERING"]>>;
            title: z.ZodOptional<z.ZodString>;
            version: z.ZodOptional<z.ZodString>;
            /**
             * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
             * By default, the model generates embeddings with 768 dimensions. Models such as
             * `text-embedding-004`, `text-embedding-005`, and `text-multilingual-embedding-002`
             * allow the output dimensionality to be adjusted between 1 and 768.
             * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
             **/
            outputDimensionality: z.ZodOptional<z.ZodNumber>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /** Override the API key provided at plugin initialization. */
            apiKey: z.ZodOptional<z.ZodString>;
            /**
             * The `task_type` parameter is defined as the intended downstream application to help the model
             * produce better quality embeddings.
             **/
            taskType: z.ZodOptional<z.ZodEnum<["RETRIEVAL_DOCUMENT", "RETRIEVAL_QUERY", "SEMANTIC_SIMILARITY", "CLASSIFICATION", "CLUSTERING"]>>;
            title: z.ZodOptional<z.ZodString>;
            version: z.ZodOptional<z.ZodString>;
            /**
             * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
             * By default, the model generates embeddings with 768 dimensions. Models such as
             * `text-embedding-004`, `text-embedding-005`, and `text-multilingual-embedding-002`
             * allow the output dimensionality to be adjusted between 1 and 768.
             * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
             **/
            outputDimensionality: z.ZodOptional<z.ZodNumber>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /** Override the API key provided at plugin initialization. */
            apiKey: z.ZodOptional<z.ZodString>;
            /**
             * The `task_type` parameter is defined as the intended downstream application to help the model
             * produce better quality embeddings.
             **/
            taskType: z.ZodOptional<z.ZodEnum<["RETRIEVAL_DOCUMENT", "RETRIEVAL_QUERY", "SEMANTIC_SIMILARITY", "CLASSIFICATION", "CLUSTERING"]>>;
            title: z.ZodOptional<z.ZodString>;
            version: z.ZodOptional<z.ZodString>;
            /**
             * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
             * By default, the model generates embeddings with 768 dimensions. Models such as
             * `text-embedding-004`, `text-embedding-005`, and `text-multilingual-embedding-002`
             * allow the output dimensionality to be adjusted between 1 and 768.
             * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
             **/
            outputDimensionality: z.ZodOptional<z.ZodNumber>;
        }, z.ZodTypeAny, "passthrough">>>;
    };
};

export { type EmbeddingConfig, EmbeddingConfigSchema, type EmbeddingConfigSchemaType, type KnownModels, TEST_ONLY, defineEmbedder, defineKnownModels, listActions, model };
