import { z, ActionMetadata, Genkit } from 'genkit';
import { ModelReference, ModelAction } from 'genkit/model';
import { Model, GoogleAIPluginOptions } from './types.js';
import '../common/types.js';

/**
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

declare const GeminiConfigSchema: z.ZodObject<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
}, z.ZodTypeAny, "passthrough">>;
type GeminiConfigSchemaType = typeof GeminiConfigSchema;
type GeminiConfig = z.infer<GeminiConfigSchemaType>;
declare const GeminiTtsConfigSchema: z.ZodObject<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
} & {
    speechConfig: z.ZodOptional<z.ZodObject<{
        voiceConfig: z.ZodOptional<z.ZodObject<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>>;
        multiSpeakerVoiceConfig: z.ZodOptional<z.ZodObject<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        voiceConfig: z.ZodOptional<z.ZodObject<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>>;
        multiSpeakerVoiceConfig: z.ZodOptional<z.ZodObject<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        voiceConfig: z.ZodOptional<z.ZodObject<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>>;
        multiSpeakerVoiceConfig: z.ZodOptional<z.ZodObject<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
} & {
    speechConfig: z.ZodOptional<z.ZodObject<{
        voiceConfig: z.ZodOptional<z.ZodObject<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>>;
        multiSpeakerVoiceConfig: z.ZodOptional<z.ZodObject<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        voiceConfig: z.ZodOptional<z.ZodObject<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>>;
        multiSpeakerVoiceConfig: z.ZodOptional<z.ZodObject<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        voiceConfig: z.ZodOptional<z.ZodObject<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>>;
        multiSpeakerVoiceConfig: z.ZodOptional<z.ZodObject<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
} & {
    speechConfig: z.ZodOptional<z.ZodObject<{
        voiceConfig: z.ZodOptional<z.ZodObject<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>>;
        multiSpeakerVoiceConfig: z.ZodOptional<z.ZodObject<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        voiceConfig: z.ZodOptional<z.ZodObject<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>>;
        multiSpeakerVoiceConfig: z.ZodOptional<z.ZodObject<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        voiceConfig: z.ZodOptional<z.ZodObject<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
            }, z.ZodTypeAny, "passthrough">>>;
        }, z.ZodTypeAny, "passthrough">>>;
        multiSpeakerVoiceConfig: z.ZodOptional<z.ZodObject<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            speakerVoiceConfigs: z.ZodArray<z.ZodObject<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                speaker: z.ZodString;
                voiceConfig: z.ZodObject<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                    prebuiltVoiceConfig: z.ZodOptional<z.ZodObject<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
                        voiceName: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["Zephyr", "Puck", "Charon", "Kore", "Fenrir", "Leda", "Orus", "Aoede", "Callirrhoe", "Autonoe", "Enceladus", "Iapetus", "Umbriel", "Algieba", "Despina", "Erinome", "Algenib", "Rasalgethi", "Laomedeia", "Achernar", "Alnilam", "Schedar", "Gacrux", "Pulcherrima", "Achird", "Zubenelgenubi", "Vindemiatrix", "Sadachbia", "Sadaltager", "Sulafat"]>, z.ZodString]>>;
                    }, z.ZodTypeAny, "passthrough">>>;
                }, z.ZodTypeAny, "passthrough">>;
            }, z.ZodTypeAny, "passthrough">>, "many">;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, z.ZodTypeAny, "passthrough">>;
type GeminiTtsConfigSchemaType = typeof GeminiTtsConfigSchema;
type GeminiTtsConfig = z.infer<GeminiTtsConfigSchemaType>;
declare const GemmaConfigSchema: z.ZodObject<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    topP: z.ZodOptional<z.ZodNumber>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
} & {
    temperature: z.ZodOptional<z.ZodNumber>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    topP: z.ZodOptional<z.ZodNumber>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
} & {
    temperature: z.ZodOptional<z.ZodNumber>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    apiKey: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_SEXUALLY_EXPLICIT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_DANGEROUS_CONTENT"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    codeExecution: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>]>>;
    contextCache: z.ZodOptional<z.ZodBoolean>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    responseModalities: z.ZodOptional<z.ZodArray<z.ZodEnum<["TEXT", "IMAGE", "AUDIO"]>, "many">>;
    googleSearchRetrieval: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>]>>;
    topP: z.ZodOptional<z.ZodNumber>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
} & {
    temperature: z.ZodOptional<z.ZodNumber>;
}, z.ZodTypeAny, "passthrough">>;
type GemmaConfigSchemaType = typeof GemmaConfigSchema;
type GemmaConfig = z.infer<GemmaConfigSchemaType>;
type ConfigSchemaType = GeminiConfigSchemaType | GeminiTtsConfigSchemaType | GemmaConfigSchemaType;
declare const KNOWN_GEMINI_MODELS: {
    'gemini-2.5-pro': ModelReference<ConfigSchemaType>;
    'gemini-2.5-flash': ModelReference<ConfigSchemaType>;
    'gemini-2.5-flash-lite': ModelReference<ConfigSchemaType>;
    'gemini-2.5-flash-image-preview': ModelReference<ConfigSchemaType>;
    'gemini-2.0-flash': ModelReference<ConfigSchemaType>;
    'gemini-2.0-flash-preview-image-generation': ModelReference<ConfigSchemaType>;
    'gemini-2.0-flash-lite': ModelReference<ConfigSchemaType>;
};
type KnownGeminiModels = keyof typeof KNOWN_GEMINI_MODELS;
type GeminiModelName = `gemini-${string}`;
declare function isGeminiModelName(value: string): value is GeminiModelName;
declare const KNOWN_TTS_MODELS: {
    'gemini-2.5-flash-preview-tts': ModelReference<ConfigSchemaType>;
    'gemini-2.5-pro-preview-tts': ModelReference<ConfigSchemaType>;
};
type KnownTtsModels = keyof typeof KNOWN_TTS_MODELS;
type TTSModelName = `gemini-${string}-tts`;
declare function isTTSModelName(value: string): value is TTSModelName;
declare const KNOWN_GEMMA_MODELS: {
    readonly 'gemma-3-12b-it': ModelReference<ConfigSchemaType>;
    readonly 'gemma-3-1b-it': ModelReference<ConfigSchemaType>;
    readonly 'gemma-3-27b-it': ModelReference<ConfigSchemaType>;
    readonly 'gemma-3-4b-it': ModelReference<ConfigSchemaType>;
    readonly 'gemma-3n-e4b-it': ModelReference<ConfigSchemaType>;
};
type KnownGemmaModels = keyof typeof KNOWN_GEMMA_MODELS;
type GemmaModelName = `gemma-${string}`;
declare function isGemmaModelName(value: string): value is GemmaModelName;
declare function model(version: string, config?: GeminiConfig | GeminiTtsConfig | GemmaConfig): ModelReference<ConfigSchemaType>;
declare function listActions(models: Model[]): ActionMetadata[];
declare function defineKnownModels(ai: Genkit, options?: GoogleAIPluginOptions): void;
/**
 * Defines a new GoogleAI Gemini model.
 */
declare function defineModel(ai: Genkit, name: string, pluginOptions?: GoogleAIPluginOptions): ModelAction;
declare const TEST_ONLY: {
    KNOWN_MODELS: {
        'gemma-3-12b-it': ModelReference<ConfigSchemaType>;
        'gemma-3-1b-it': ModelReference<ConfigSchemaType>;
        'gemma-3-27b-it': ModelReference<ConfigSchemaType>;
        'gemma-3-4b-it': ModelReference<ConfigSchemaType>;
        'gemma-3n-e4b-it': ModelReference<ConfigSchemaType>;
        'gemini-2.5-flash-preview-tts': ModelReference<ConfigSchemaType>;
        'gemini-2.5-pro-preview-tts': ModelReference<ConfigSchemaType>;
        'gemini-2.5-pro': ModelReference<ConfigSchemaType>;
        'gemini-2.5-flash': ModelReference<ConfigSchemaType>;
        'gemini-2.5-flash-lite': ModelReference<ConfigSchemaType>;
        'gemini-2.5-flash-image-preview': ModelReference<ConfigSchemaType>;
        'gemini-2.0-flash': ModelReference<ConfigSchemaType>;
        'gemini-2.0-flash-preview-image-generation': ModelReference<ConfigSchemaType>;
        'gemini-2.0-flash-lite': ModelReference<ConfigSchemaType>;
    };
};

export { type GeminiConfig, GeminiConfigSchema, type GeminiConfigSchemaType, type GeminiModelName, type GeminiTtsConfig, GeminiTtsConfigSchema, type GeminiTtsConfigSchemaType, type GemmaConfig, GemmaConfigSchema, type GemmaConfigSchemaType, type GemmaModelName, type KnownGeminiModels, type KnownGemmaModels, type KnownTtsModels, TEST_ONLY, type TTSModelName, defineKnownModels, defineModel, isGeminiModelName, isGemmaModelName, isTTSModelName, listActions, model };
