import { ModelReference, z, EmbedderReference } from 'genkit';
import { GenkitPlugin } from 'genkit/plugin';
import { GoogleAIPluginOptions } from './types.js';
import { EmbeddingConfig, EmbeddingConfigSchemaType } from './embedder.js';
import { KnownGemmaModels, GemmaModelName, GemmaConfig, GemmaConfigSchemaType, KnownTtsModels, TTSModelName, GeminiTtsConfig, GeminiTtsConfigSchemaType, KnownGeminiModels, GeminiModelName, GeminiConfig, GeminiConfigSchemaType } from './gemini.js';
import { KnownModels, ImagenModelName, ImagenConfig, ImagenConfigSchemaType } from './imagen.js';
import { KnownModels as KnownModels$1, VeoModelName, VeoConfig, VeoConfigSchemaType } from './veo.js';
import '../common/types.js';
import 'genkit/model';

/**
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Google Gemini Developer API plugin.
 */
declare function googleAIPlugin(options?: GoogleAIPluginOptions): GenkitPlugin;
type GoogleAIPlugin = {
    (pluginOptions?: GoogleAIPluginOptions): GenkitPlugin;
    model(name: KnownGemmaModels | (GemmaModelName & {}), config: GemmaConfig): ModelReference<GemmaConfigSchemaType>;
    model(name: KnownTtsModels | (TTSModelName & {}), config: GeminiTtsConfig): ModelReference<GeminiTtsConfigSchemaType>;
    model(name: KnownGeminiModels | (GeminiModelName & {}), config?: GeminiConfig): ModelReference<GeminiConfigSchemaType>;
    model(name: KnownModels | (ImagenModelName & {}), config?: ImagenConfig): ModelReference<ImagenConfigSchemaType>;
    model(name: KnownModels$1 | (VeoModelName & {}), config?: VeoConfig): ModelReference<VeoConfigSchemaType>;
    model(name: string, config?: any): ModelReference<z.ZodTypeAny>;
    embedder(name: string, config?: EmbeddingConfig): EmbedderReference<EmbeddingConfigSchemaType>;
};
/**
 * Google Gemini Developer API plugin.
 */
declare const googleAI: GoogleAIPlugin;

export { EmbeddingConfig, GeminiConfig, GeminiTtsConfig, type GoogleAIPlugin, GoogleAIPluginOptions, ImagenConfig, googleAI as default, googleAI, googleAIPlugin };
