"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var imagen_exports = {};
__export(imagen_exports, {
  ImagenConfigSchema: () => ImagenConfigSchema,
  KNOWN_MODELS: () => KNOWN_MODELS,
  TEST_ONLY: () => TEST_ONLY,
  defineKnownModels: () => defineKnownModels,
  defineModel: () => defineModel,
  isImagenModelName: () => isImagenModelName,
  listActions: () => listActions,
  model: () => model
});
module.exports = __toCommonJS(imagen_exports);
var import_genkit = require("genkit");
var import_model = require("genkit/model");
var import_client = require("./client.js");
var import_converters = require("./converters.js");
var import_utils = require("./utils.js");
const ImagenConfigSchema = import_model.GenerationCommonConfigSchema.extend({
  // TODO: Remove common config schema extension since Imagen models don't support
  // most of the common config parameters. Also, add more parameters like sampleCount
  // from the above reference.
  language: import_genkit.z.enum(["auto", "en", "es", "hi", "ja", "ko", "pt", "zh-TW", "zh", "zh-CN"]).describe("Language of the prompt text.").optional(),
  aspectRatio: import_genkit.z.enum(["1:1", "9:16", "16:9", "3:4", "4:3"]).describe("Desired aspect ratio of the output image.").optional(),
  negativePrompt: import_genkit.z.string().describe(
    'A description of what to discourage in the generated images. For example: "animals" (removes animals), "blurry" (makes the image clearer), "text" (removes text), or "cropped" (removes cropped images).'
  ).optional(),
  seed: import_genkit.z.number().int().min(1).max(2147483647).describe(
    "Controls the randomization of the image generation process. Use the same seed across requests to provide consistency, or change it to introduce variety in the response."
  ).optional(),
  location: import_genkit.z.string().describe("Google Cloud region e.g. us-central1.").optional(),
  personGeneration: import_genkit.z.enum(["dont_allow", "allow_adult", "allow_all"]).describe("Control if/how images of people will be generated by the model.").optional(),
  safetySetting: import_genkit.z.enum(["block_most", "block_some", "block_few", "block_fewest"]).describe("Adds a filter level to safety filtering.").optional(),
  addWatermark: import_genkit.z.boolean().describe("Add an invisible watermark to the generated images.").optional(),
  storageUri: import_genkit.z.string().describe("Cloud Storage URI to store the generated images.").optional(),
  mode: import_genkit.z.enum(["upscale"]).describe("Mode must be set for upscaling requests.").optional(),
  /**
   * Describes the editing intention for the request.
   *
   * See https://cloud.google.com/vertex-ai/generative-ai/docs/model-reference/imagen-api#edit_images_2 for details.
   */
  editConfig: import_genkit.z.object({
    editMode: import_genkit.z.enum([
      "inpainting-insert",
      "inpainting-remove",
      "outpainting",
      "product-image"
    ]).describe("Editing intention for the request.").optional(),
    maskMode: import_genkit.z.object({
      maskType: import_genkit.z.enum(["background", "foreground", "semantic"]).describe(
        '"background" automatically generates a mask for all regions except the primary subject(s) of the image, "foreground" automatically generates a mask for the primary subjects(s) of the image. "semantic" segments one or more of the segmentation classes using class ID.'
      ),
      classes: import_genkit.z.array(import_genkit.z.number()).describe("List of class IDs for segmentation.").length(5).optional()
    }).describe(
      "Prompts the model to generate a mask instead of you needing to provide one. Consequently, when you provide this parameter you can omit a mask object."
    ).optional(),
    maskDilation: import_genkit.z.number().describe("Dilation percentage of the mask provided.").min(0).max(1).optional(),
    guidanceScale: import_genkit.z.number().describe(
      "Controls how much the model adheres to the text prompt. Large values increase output and prompt alignment, but may compromise image quality. Suggested values are 0-9 (low strength), 10-20 (medium strength), 21+ (high strength)."
    ).optional(),
    productPosition: import_genkit.z.enum(["reposition", "fixed"]).describe(
      "Defines whether the product should stay fixed or be repositioned."
    ).optional()
  }).passthrough().optional(),
  upscaleConfig: import_genkit.z.object({
    upscaleFactor: import_genkit.z.enum(["x2", "x4"]).describe("The factor to upscale the image.")
  }).describe("Configuration for upscaling.").optional()
}).passthrough();
function commonRef(name, info, configSchema = ImagenConfigSchema) {
  return (0, import_model.modelRef)({
    name: `vertexai/${name}`,
    configSchema,
    info: info ?? {
      supports: {
        media: true,
        multiturn: false,
        tools: false,
        toolChoice: false,
        systemRole: false,
        output: ["media"]
      }
    }
  });
}
const GENERIC_MODEL = commonRef("imagen", {
  supports: {
    media: true,
    multiturn: true,
    tools: true,
    systemRole: true,
    output: ["media"]
  }
});
const KNOWN_MODELS = {
  "imagen-3.0-generate-002": commonRef("imagen-3.0-generate-002"),
  "imagen-3.0-generate-001": commonRef("imagen-3.0-generate-001"),
  "imagen-3.0-capability-001": commonRef("imagen-3.0-capability-001"),
  "imagen-3.0-fast-generate-001": commonRef("imagen-3.0-fast-generate-001"),
  "imagen-4.0-generate-preview-06-06": commonRef(
    "imagen-4.0-generate-preview-06-06"
  ),
  "imagen-4.0-ultra-generate-preview-06-06": commonRef(
    "imagen-4.0-ultra-generate-preview-06-06"
  )
};
function isImagenModelName(value) {
  return !!value?.startsWith("imagen-");
}
function model(version, config = {}) {
  const name = (0, import_utils.checkModelName)(version);
  if (KNOWN_MODELS[name]) {
    return KNOWN_MODELS[name].withConfig(config);
  }
  return (0, import_model.modelRef)({
    name: `vertexai/${name}`,
    config,
    configSchema: ImagenConfigSchema,
    info: {
      ...GENERIC_MODEL.info
    }
  });
}
function listActions(models) {
  return models.filter((m) => isImagenModelName((0, import_utils.modelName)(m.name))).map((m) => {
    const ref = model(m.name);
    return (0, import_genkit.modelActionMetadata)({
      name: ref.name,
      info: ref.info,
      configSchema: ref.configSchema
    });
  });
}
function defineKnownModels(ai, clientOptions, pluginOptions) {
  for (const name of Object.keys(KNOWN_MODELS)) {
    defineModel(ai, name, clientOptions, pluginOptions);
  }
}
function defineModel(ai, name, clientOptions, pluginOptions) {
  const ref = model(name);
  return ai.defineModel(
    {
      apiVersion: "v2",
      name: ref.name,
      ...ref.info,
      configSchema: ref.configSchema
    },
    async (request, { abortSignal }) => {
      const clientOpt = { ...clientOptions, signal: abortSignal };
      const imagenPredictRequest = (0, import_converters.toImagenPredictRequest)(request);
      const response = await (0, import_client.imagenPredict)(
        (0, import_utils.extractVersion)(ref),
        imagenPredictRequest,
        clientOpt
      );
      if (!response.predictions || response.predictions.length == 0) {
        throw new Error(
          "Model returned no predictions. Possibly due to content filters."
        );
      }
      return (0, import_converters.fromImagenResponse)(response, request);
    }
  );
}
const TEST_ONLY = {
  GENERIC_MODEL,
  KNOWN_MODELS
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ImagenConfigSchema,
  KNOWN_MODELS,
  TEST_ONLY,
  defineKnownModels,
  defineModel,
  isImagenModelName,
  listActions,
  model
});
//# sourceMappingURL=imagen.js.map