"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var types_exports = {};
__export(types_exports, {
  FunctionCallingMode: () => import_types.FunctionCallingMode,
  HarmBlockThreshold: () => import_types.HarmBlockThreshold,
  HarmCategory: () => import_types.HarmCategory,
  TaskTypeSchema: () => import_types.TaskTypeSchema,
  isCodeExecutionTool: () => import_types.isCodeExecutionTool,
  isFunctionDeclarationsTool: () => import_types.isFunctionDeclarationsTool,
  isGoogleSearchRetrievalTool: () => import_types.isGoogleSearchRetrievalTool,
  isMultimodalEmbeddingPrediction: () => isMultimodalEmbeddingPrediction,
  isObject: () => import_types.isObject,
  isRetrievalTool: () => import_types.isRetrievalTool
});
module.exports = __toCommonJS(types_exports);
var import_types = require("../common/types.js");
function isMultimodalEmbeddingPrediction(value) {
  if (!(0, import_types.isObject)(value)) {
    return false;
  }
  if (!value.textEmbedding && !value.imageEmbedding && !value.videoEmbeddings) {
    return false;
  }
  if (value.textEmbedding && !Array.isArray(value.textEmbedding)) {
    return false;
  }
  if (value.imageEmbedding && !Array.isArray(value.imageEmbedding)) {
    return false;
  }
  if (value.videoEmbeddings && !Array.isArray(value.videoEmbeddings)) {
    return false;
  }
  if (value.videoEmbeddings) {
    for (const emb of value.videoEmbeddings) {
      if (!(0, import_types.isObject)(emb)) {
        return false;
      }
      if (!emb.embedding || !Array.isArray(emb.embedding)) {
        return false;
      }
    }
  }
  return true;
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  FunctionCallingMode,
  HarmBlockThreshold,
  HarmCategory,
  TaskTypeSchema,
  isCodeExecutionTool,
  isFunctionDeclarationsTool,
  isGoogleSearchRetrievalTool,
  isMultimodalEmbeddingPrediction,
  isObject,
  isRetrievalTool
});
//# sourceMappingURL=types.js.map