"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.startServer = startServer;
const trpcExpress = __importStar(require("@trpc/server/adapters/express"));
const bodyParser = __importStar(require("body-parser"));
const clc = __importStar(require("colorette"));
const express_1 = __importDefault(require("express"));
const os_1 = __importDefault(require("os"));
const path_1 = __importDefault(require("path"));
const utils_1 = require("../utils");
const logger_1 = require("../utils/logger");
const package_1 = require("../utils/package");
const ui_assets_1 = require("../utils/ui-assets");
const router_1 = require("./router");
const MAX_PAYLOAD_SIZE = 30000000;
const UI_ASSETS_GCS_BUCKET = `https://storage.googleapis.com/genkit-assets`;
const UI_ASSETS_ZIP_FILE_NAME = `${package_1.toolsPackage.version}.zip`;
const UI_ASSETS_ZIP_GCS_PATH = `${UI_ASSETS_GCS_BUCKET}/${UI_ASSETS_ZIP_FILE_NAME}`;
const UI_ASSETS_ROOT = path_1.default.resolve(os_1.default.homedir(), '.genkit', 'assets', package_1.toolsPackage.version);
const UI_ASSETS_SERVE_PATH = path_1.default.resolve(UI_ASSETS_ROOT, 'ui', 'browser');
const API_BASE_PATH = '/api';
function startServer(manager, port) {
    let server;
    const app = (0, express_1.default)();
    (0, ui_assets_1.downloadAndExtractUiAssets)({
        fileUrl: UI_ASSETS_ZIP_GCS_PATH,
        extractPath: UI_ASSETS_ROOT,
        zipFileName: UI_ASSETS_ZIP_FILE_NAME,
    });
    app.use(express_1.default.static(UI_ASSETS_SERVE_PATH));
    app.options('/api/streamAction', async (req, res) => {
        res.setHeader('Access-Control-Allow-Origin', '*');
        res.setHeader('Access-Control-Allow-Headers', 'Content-Type');
        res.status(200).send('');
    });
    app.post('/api/streamAction', bodyParser.json({ limit: MAX_PAYLOAD_SIZE }), async (req, res) => {
        const { key, input, context } = req.body;
        res.writeHead(200, {
            'Access-Control-Allow-Origin': '*',
            'Access-Control-Allow-Headers': 'Content-Type',
            'Content-Type': 'text/plain',
            'Transfer-Encoding': 'chunked',
        });
        try {
            const result = await manager.runAction({ key, input, context }, (chunk) => {
                res.write(JSON.stringify(chunk) + '\n');
            });
            res.write(JSON.stringify(result));
        }
        catch (err) {
            res.write(JSON.stringify({ error: err.data }));
        }
        res.end();
    });
    app.get('/api/__health', (_, res) => {
        res.status(200).send('');
    });
    app.post('/api/__quitquitquit', (_, res) => {
        logger_1.logger.debug('Shutting down tools API');
        res.status(200).send('Server is shutting down');
        server.close(() => {
            process.exit(0);
        });
    });
    app.use(API_BASE_PATH, (req, res, next) => {
        res.setHeader('Access-Control-Allow-Origin', '*');
        res.setHeader('Access-Control-Allow-Headers', 'Content-Type');
        if (req.method === 'OPTIONS')
            res.send('');
        else
            next();
    }, trpcExpress.createExpressMiddleware({
        router: (0, router_1.TOOLS_SERVER_ROUTER)(manager),
        maxBodySize: MAX_PAYLOAD_SIZE,
    }));
    app.all('*', (_, res) => {
        res.status(200).sendFile('/', { root: UI_ASSETS_SERVE_PATH });
    });
    const errorHandler = (error, request, response, next) => {
        if (error instanceof Error) {
            logger_1.logger.error(error.stack);
        }
        return response.status(500).send(error);
    };
    app.use(errorHandler);
    server = app.listen(port, async () => {
        const uiUrl = 'http://localhost:' + port;
        const projectRoot = manager.projectRoot;
        logger_1.logger.info(`${clc.green(clc.bold('Project root:'))} ${projectRoot}`);
        logger_1.logger.info(`${clc.green(clc.bold('Genkit Developer UI:'))} ${uiUrl}`);
        await (0, utils_1.writeToolsInfoFile)(uiUrl, projectRoot);
    });
    return new Promise((resolve) => {
        server.once('close', resolve);
    });
}
//# sourceMappingURL=server.js.map