"use strict";
// Copyright 2018 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.makeChildLogger = makeChildLogger;
const index_1 = require("../index");
function makeChildLogger(logger, trace, span, sampled) {
    return logger.child({
        [index_1.LOGGING_TRACE_KEY]: trace,
        [index_1.LOGGING_SPAN_KEY]: span,
        [index_1.LOGGING_SAMPLED_KEY]: sampled,
    });
}
//# sourceMappingURL=make-child-logger.js.map