import { Button } from "@/components/ui/button";
import { Card, CardContent, CardDescription, CardFooter, CardHeader, CardTitle } from "@/components/ui/card";
import { Input } from "@/components/ui/input";
import { Label } from "@/components/ui/label";
import { Logo } from "@/components/logo";
import Link from "next/link";

export default function LoginPage() {
  return (
    <div className="flex items-center justify-center min-h-[calc(100vh-14rem)] py-12 px-4 sm:px-6 lg:px-8">
      <div className="w-full max-w-md space-y-8">
        <div className="text-center">
           <div className="inline-block">
             <Logo />
           </div>
          <h2 className="mt-6 text-center text-3xl font-headline font-bold tracking-tight text-primary">
            Sign in to your account
          </h2>
        </div>
        <Card>
          <CardHeader>
             <CardTitle>Welcome back</CardTitle>
             <CardDescription>Enter your credentials to access your account.</CardDescription>
          </CardHeader>
          <CardContent className="space-y-4">
            <div className="space-y-2">
              <Label htmlFor="email">Email address</Label>
              <Input id="email" type="email" required placeholder="you@example.com" />
            </div>
            <div className="space-y-2">
                <div className="flex items-center justify-between">
                    <Label htmlFor="password">Password</Label>
                    <div className="text-sm">
                        <Link href="#" className="font-medium text-primary hover:text-primary/90">
                            Forgot your password?
                        </Link>
                    </div>
                </div>
              <Input id="password" type="password" required placeholder="••••••••" />
            </div>
          </CardContent>
          <CardFooter className="flex flex-col gap-4">
            <Button className="w-full">Sign in</Button>
            <p className="text-center text-sm text-muted-foreground">
                Don't have an account?{' '}
                <Link href="/register" className="font-medium text-primary hover:text-primary/90">
                    Register here
                </Link>
            </p>
          </CardFooter>
        </Card>
      </div>
    </div>
  );
}
