"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var flow_exports = {};
__export(flow_exports, {
  defineFlow: () => defineFlow,
  flow: () => flow,
  run: () => run
});
module.exports = __toCommonJS(flow_exports);
var import_action = require("./action.js");
var import_tracing = require("./tracing.js");
function flow(config, fn) {
  const resolvedConfig = typeof config === "string" ? { name: config } : config;
  return flowAction(resolvedConfig, fn);
}
function defineFlow(registry, config, fn) {
  const f = flow(config, fn);
  registry.registerAction("flow", f);
  return f;
}
function flowAction(config, fn) {
  return (0, import_action.action)(
    {
      actionType: "flow",
      name: config.name,
      inputSchema: config.inputSchema,
      outputSchema: config.outputSchema,
      streamSchema: config.streamSchema,
      metadata: config.metadata
    },
    async (input, { sendChunk, context, trace, abortSignal, streamingRequested }) => {
      const ctx = sendChunk;
      ctx.sendChunk = sendChunk;
      ctx.context = context;
      ctx.trace = trace;
      ctx.abortSignal = abortSignal;
      ctx.streamingRequested = streamingRequested;
      return fn(input, ctx);
    }
  );
}
function run(name, funcOrInput, fnOrRegistry, _) {
  let func;
  let input;
  let hasInput = false;
  if (typeof funcOrInput === "function") {
    func = funcOrInput;
  } else {
    input = funcOrInput;
    hasInput = true;
  }
  if (typeof fnOrRegistry === "function") {
    func = fnOrRegistry;
  }
  if (!func) {
    throw new Error("unable to resolve run function");
  }
  return (0, import_tracing.runInNewSpan)(
    {
      metadata: { name },
      labels: {
        [import_tracing.SPAN_TYPE_ATTR]: "flowStep"
      }
    },
    async (meta) => {
      meta.input = input;
      const output = hasInput ? await func(input) : await func();
      meta.output = JSON.stringify(output);
      return output;
    }
  );
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  defineFlow,
  flow,
  run
});
//# sourceMappingURL=flow.js.map