"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var types_exports = {};
__export(types_exports, {
  BlockReason: () => BlockReason,
  DynamicRetrievalMode: () => DynamicRetrievalMode,
  ExecutableCodeLanguage: () => ExecutableCodeLanguage,
  FinishReason: () => FinishReason,
  FunctionCallingMode: () => FunctionCallingMode,
  HarmBlockThreshold: () => HarmBlockThreshold,
  HarmCategory: () => HarmCategory,
  HarmProbability: () => HarmProbability,
  HarmSeverity: () => HarmSeverity,
  Outcome: () => Outcome,
  SchemaType: () => SchemaType,
  TaskTypeSchema: () => TaskTypeSchema,
  isCodeExecutionTool: () => isCodeExecutionTool,
  isFunctionDeclarationsTool: () => isFunctionDeclarationsTool,
  isGoogleSearchRetrievalTool: () => isGoogleSearchRetrievalTool,
  isObject: () => isObject,
  isRetrievalTool: () => isRetrievalTool
});
module.exports = __toCommonJS(types_exports);
var import_genkit = require("genkit");
var FunctionCallingMode = /* @__PURE__ */ ((FunctionCallingMode2) => {
  FunctionCallingMode2["MODE_UNSPECIFIED"] = "MODE_UNSPECIFIED";
  FunctionCallingMode2["AUTO"] = "AUTO";
  FunctionCallingMode2["ANY"] = "ANY";
  FunctionCallingMode2["NONE"] = "NONE";
  return FunctionCallingMode2;
})(FunctionCallingMode || {});
function isObject(value) {
  return typeof value === "object" && value !== null;
}
var BlockReason = /* @__PURE__ */ ((BlockReason2) => {
  BlockReason2["BLOCKED_REASON_UNSPECIFIED"] = "BLOCKED_REASON_UNSPECIFIED";
  BlockReason2["BLOCK_REASON_UNSPECIFIED"] = "BLOCK_REASON_UNSPECIFIED";
  BlockReason2["SAFETY"] = "SAFETY";
  BlockReason2["OTHER"] = "OTHER";
  BlockReason2["BLOCKLIST"] = "BLOCKLIST";
  BlockReason2["PROHIBITED_CONTENT"] = "PROHIBITED_CONTENT";
  return BlockReason2;
})(BlockReason || {});
var HarmCategory = /* @__PURE__ */ ((HarmCategory2) => {
  HarmCategory2["HARM_CATEGORY_UNSPECIFIED"] = "HARM_CATEGORY_UNSPECIFIED";
  HarmCategory2["HARM_CATEGORY_HATE_SPEECH"] = "HARM_CATEGORY_HATE_SPEECH";
  HarmCategory2["HARM_CATEGORY_SEXUALLY_EXPLICIT"] = "HARM_CATEGORY_SEXUALLY_EXPLICIT";
  HarmCategory2["HARM_CATEGORY_HARASSMENT"] = "HARM_CATEGORY_HARASSMENT";
  HarmCategory2["HARM_CATEGORY_DANGEROUS_CONTENT"] = "HARM_CATEGORY_DANGEROUS_CONTENT";
  HarmCategory2["HARM_CATEGORY_CIVIC_INTEGRITY"] = "HARM_CATEGORY_CIVIC_INTEGRITY";
  return HarmCategory2;
})(HarmCategory || {});
var HarmBlockThreshold = /* @__PURE__ */ ((HarmBlockThreshold2) => {
  HarmBlockThreshold2["HARM_BLOCK_THRESHOLD_UNSPECIFIED"] = "HARM_BLOCK_THRESHOLD_UNSPECIFIED";
  HarmBlockThreshold2["BLOCK_LOW_AND_ABOVE"] = "BLOCK_LOW_AND_ABOVE";
  HarmBlockThreshold2["BLOCK_MEDIUM_AND_ABOVE"] = "BLOCK_MEDIUM_AND_ABOVE";
  HarmBlockThreshold2["BLOCK_ONLY_HIGH"] = "BLOCK_ONLY_HIGH";
  HarmBlockThreshold2["BLOCK_NONE"] = "BLOCK_NONE";
  HarmBlockThreshold2["OFF"] = "OFF";
  return HarmBlockThreshold2;
})(HarmBlockThreshold || {});
var HarmProbability = /* @__PURE__ */ ((HarmProbability2) => {
  HarmProbability2["HARM_PROBABILITY_UNSPECIFIED"] = "HARM_PROBABILITY_UNSPECIFIED";
  HarmProbability2["NEGLIGIBLE"] = "NEGLIGIBLE";
  HarmProbability2["LOW"] = "LOW";
  HarmProbability2["MEDIUM"] = "MEDIUM";
  HarmProbability2["HIGH"] = "HIGH";
  return HarmProbability2;
})(HarmProbability || {});
var DynamicRetrievalMode = /* @__PURE__ */ ((DynamicRetrievalMode2) => {
  DynamicRetrievalMode2["MODE_UNSPECIFIED"] = "MODE_UNSPECIFIED";
  DynamicRetrievalMode2["MODE_DYNAMIC"] = "MODE_DYNAMIC";
  return DynamicRetrievalMode2;
})(DynamicRetrievalMode || {});
function isGoogleSearchRetrievalTool(tool) {
  return tool.googleSearchRetrieval !== void 0 || tool.googleSearch !== void 0;
}
var HarmSeverity = /* @__PURE__ */ ((HarmSeverity2) => {
  HarmSeverity2["HARM_SEVERITY_UNSPECIFIED"] = "HARM_SEVERITY_UNSPECIFIED";
  HarmSeverity2["HARM_SEVERITY_NEGLIGIBLE"] = "HARM_SEVERITY_NEGLIGIBLE";
  HarmSeverity2["HARM_SEVERITY_LOW"] = "HARM_SEVERITY_LOW";
  HarmSeverity2["HARM_SEVERITY_MEDIUM"] = "HARM_SEVERITY_MEDIUM";
  HarmSeverity2["HARM_SEVERITY_HIGH"] = "HARM_SEVERITY_HIGH";
  return HarmSeverity2;
})(HarmSeverity || {});
var SchemaType = /* @__PURE__ */ ((SchemaType2) => {
  SchemaType2["STRING"] = "STRING";
  SchemaType2["NUMBER"] = "NUMBER";
  SchemaType2["INTEGER"] = "INTEGER";
  SchemaType2["BOOLEAN"] = "BOOLEAN";
  SchemaType2["ARRAY"] = "ARRAY";
  SchemaType2["OBJECT"] = "OBJECT";
  return SchemaType2;
})(SchemaType || {});
const TaskTypeSchema = import_genkit.z.enum([
  "RETRIEVAL_DOCUMENT",
  "RETRIEVAL_QUERY",
  "SEMANTIC_SIMILARITY",
  "CLASSIFICATION",
  "CLUSTERING"
]);
var FinishReason = /* @__PURE__ */ ((FinishReason2) => {
  FinishReason2["FINISH_REASON_UNSPECIFIED"] = "FINISH_REASON_UNSPECIFIED";
  FinishReason2["STOP"] = "STOP";
  FinishReason2["MAX_TOKENS"] = "MAX_TOKENS";
  FinishReason2["SAFETY"] = "SAFETY";
  FinishReason2["RECITATION"] = "RECITATION";
  FinishReason2["LANGUAGE"] = "LANGUAGE";
  FinishReason2["BLOCKLIST"] = "BLOCKLIST";
  FinishReason2["PROHIBITED_CONTENT"] = "PROHIBITED_CONTENT";
  FinishReason2["SPII"] = "SPII";
  FinishReason2["MALFORMED_FUNCTION_CALL"] = "MALFORMED_FUNCTION_CALL";
  FinishReason2["OTHER"] = "OTHER";
  return FinishReason2;
})(FinishReason || {});
var ExecutableCodeLanguage = /* @__PURE__ */ ((ExecutableCodeLanguage2) => {
  ExecutableCodeLanguage2["LANGUAGE_UNSPECIFIED"] = "LANGUAGE_UNSPECIFIED";
  ExecutableCodeLanguage2["PYTHON"] = "PYTHON";
  return ExecutableCodeLanguage2;
})(ExecutableCodeLanguage || {});
var Outcome = /* @__PURE__ */ ((Outcome2) => {
  Outcome2["OUTCOME_UNSPECIFIED"] = "OUTCOME_UNSPECIFIED";
  Outcome2["OUTCOME_OK"] = "OUTCOME_OK";
  Outcome2["OUTCOME_FAILED"] = "OUTCOME_FAILED";
  Outcome2["OUTCOME_DEADLINE_EXCEEDED"] = "OUTCOME_DEADLINE_EXCEEDED";
  return Outcome2;
})(Outcome || {});
function isFunctionDeclarationsTool(tool) {
  return tool.functionDeclarations !== void 0;
}
function isCodeExecutionTool(tool) {
  return tool.codeExecution !== void 0;
}
function isRetrievalTool(tool) {
  return tool.retrieval !== void 0;
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  BlockReason,
  DynamicRetrievalMode,
  ExecutableCodeLanguage,
  FinishReason,
  FunctionCallingMode,
  HarmBlockThreshold,
  HarmCategory,
  HarmProbability,
  HarmSeverity,
  Outcome,
  SchemaType,
  TaskTypeSchema,
  isCodeExecutionTool,
  isFunctionDeclarationsTool,
  isGoogleSearchRetrievalTool,
  isObject,
  isRetrievalTool
});
//# sourceMappingURL=types.js.map