import { z, ActionMetadata, Genkit, Operation, GenerateResponseData } from 'genkit';
import { ModelReference, BackgroundModelAction, GenerateRequest } from 'genkit/model';
import { Model, GoogleAIPluginOptions, VeoParameters, VeoOperation } from './types.js';
import '../common/types.js';

/**
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * See https://ai.google.dev/gemini-api/docs/video
 */
declare const VeoConfigSchema: z.ZodObject<{
    negativePrompt: z.ZodOptional<z.ZodString>;
    aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
    personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
    durationSeconds: z.ZodOptional<z.ZodNumber>;
    enhancePrompt: z.ZodOptional<z.ZodBoolean>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    negativePrompt: z.ZodOptional<z.ZodString>;
    aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
    personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
    durationSeconds: z.ZodOptional<z.ZodNumber>;
    enhancePrompt: z.ZodOptional<z.ZodBoolean>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    negativePrompt: z.ZodOptional<z.ZodString>;
    aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
    personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
    durationSeconds: z.ZodOptional<z.ZodNumber>;
    enhancePrompt: z.ZodOptional<z.ZodBoolean>;
}, z.ZodTypeAny, "passthrough">>;
type VeoConfigSchemaType = typeof VeoConfigSchema;
type VeoConfig = z.infer<VeoConfigSchemaType>;
type ConfigSchemaType = VeoConfigSchemaType;
declare const KNOWN_MODELS: {
    readonly 'veo-3.0-generate-preview': ModelReference<z.ZodObject<{
        negativePrompt: z.ZodOptional<z.ZodString>;
        aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
        personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
        durationSeconds: z.ZodOptional<z.ZodNumber>;
        enhancePrompt: z.ZodOptional<z.ZodBoolean>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        negativePrompt: z.ZodOptional<z.ZodString>;
        aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
        personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
        durationSeconds: z.ZodOptional<z.ZodNumber>;
        enhancePrompt: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        negativePrompt: z.ZodOptional<z.ZodString>;
        aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
        personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
        durationSeconds: z.ZodOptional<z.ZodNumber>;
        enhancePrompt: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">>>;
    readonly 'veo-3.0-fast-generate-preview': ModelReference<z.ZodObject<{
        negativePrompt: z.ZodOptional<z.ZodString>;
        aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
        personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
        durationSeconds: z.ZodOptional<z.ZodNumber>;
        enhancePrompt: z.ZodOptional<z.ZodBoolean>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        negativePrompt: z.ZodOptional<z.ZodString>;
        aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
        personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
        durationSeconds: z.ZodOptional<z.ZodNumber>;
        enhancePrompt: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        negativePrompt: z.ZodOptional<z.ZodString>;
        aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
        personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
        durationSeconds: z.ZodOptional<z.ZodNumber>;
        enhancePrompt: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">>>;
    readonly 'veo-2.0-generate-001': ModelReference<z.ZodObject<{
        negativePrompt: z.ZodOptional<z.ZodString>;
        aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
        personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
        durationSeconds: z.ZodOptional<z.ZodNumber>;
        enhancePrompt: z.ZodOptional<z.ZodBoolean>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        negativePrompt: z.ZodOptional<z.ZodString>;
        aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
        personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
        durationSeconds: z.ZodOptional<z.ZodNumber>;
        enhancePrompt: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        negativePrompt: z.ZodOptional<z.ZodString>;
        aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
        personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
        durationSeconds: z.ZodOptional<z.ZodNumber>;
        enhancePrompt: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">>>;
};
type KnownModels = keyof typeof KNOWN_MODELS;
type VeoModelName = `veo-${string}`;
declare function isVeoModelName(value?: string): value is VeoModelName;
declare function model(version: string, config?: VeoConfig): ModelReference<ConfigSchemaType>;
declare function listActions(models: Model[]): ActionMetadata[];
declare function defineKnownModels(ai: Genkit, options?: GoogleAIPluginOptions): void;
/**
 * Defines a new GoogleAI Veo model.
 */
declare function defineModel(ai: Genkit, name: string, pluginOptions?: GoogleAIPluginOptions): BackgroundModelAction<VeoConfigSchemaType>;
declare function toVeoParameters(request: GenerateRequest<VeoConfigSchemaType>): VeoParameters;
declare function fromVeoOperation(apiOp: VeoOperation): Operation<GenerateResponseData>;
declare const TEST_ONLY: {
    toVeoParameters: typeof toVeoParameters;
    fromVeoOperation: typeof fromVeoOperation;
    GENERIC_MODEL: ModelReference<z.ZodObject<{
        negativePrompt: z.ZodOptional<z.ZodString>;
        aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
        personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
        durationSeconds: z.ZodOptional<z.ZodNumber>;
        enhancePrompt: z.ZodOptional<z.ZodBoolean>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        negativePrompt: z.ZodOptional<z.ZodString>;
        aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
        personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
        durationSeconds: z.ZodOptional<z.ZodNumber>;
        enhancePrompt: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        negativePrompt: z.ZodOptional<z.ZodString>;
        aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
        personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
        durationSeconds: z.ZodOptional<z.ZodNumber>;
        enhancePrompt: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">>>;
    KNOWN_MODELS: {
        readonly 'veo-3.0-generate-preview': ModelReference<z.ZodObject<{
            negativePrompt: z.ZodOptional<z.ZodString>;
            aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
            personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
            durationSeconds: z.ZodOptional<z.ZodNumber>;
            enhancePrompt: z.ZodOptional<z.ZodBoolean>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            negativePrompt: z.ZodOptional<z.ZodString>;
            aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
            personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
            durationSeconds: z.ZodOptional<z.ZodNumber>;
            enhancePrompt: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            negativePrompt: z.ZodOptional<z.ZodString>;
            aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
            personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
            durationSeconds: z.ZodOptional<z.ZodNumber>;
            enhancePrompt: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">>>;
        readonly 'veo-3.0-fast-generate-preview': ModelReference<z.ZodObject<{
            negativePrompt: z.ZodOptional<z.ZodString>;
            aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
            personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
            durationSeconds: z.ZodOptional<z.ZodNumber>;
            enhancePrompt: z.ZodOptional<z.ZodBoolean>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            negativePrompt: z.ZodOptional<z.ZodString>;
            aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
            personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
            durationSeconds: z.ZodOptional<z.ZodNumber>;
            enhancePrompt: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            negativePrompt: z.ZodOptional<z.ZodString>;
            aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
            personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
            durationSeconds: z.ZodOptional<z.ZodNumber>;
            enhancePrompt: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">>>;
        readonly 'veo-2.0-generate-001': ModelReference<z.ZodObject<{
            negativePrompt: z.ZodOptional<z.ZodString>;
            aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
            personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
            durationSeconds: z.ZodOptional<z.ZodNumber>;
            enhancePrompt: z.ZodOptional<z.ZodBoolean>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            negativePrompt: z.ZodOptional<z.ZodString>;
            aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
            personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
            durationSeconds: z.ZodOptional<z.ZodNumber>;
            enhancePrompt: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            negativePrompt: z.ZodOptional<z.ZodString>;
            aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
            personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
            durationSeconds: z.ZodOptional<z.ZodNumber>;
            enhancePrompt: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">>>;
    };
};

export { type KnownModels, TEST_ONLY, type VeoConfig, VeoConfigSchema, type VeoConfigSchemaType, type VeoModelName, defineKnownModels, defineModel, isVeoModelName, listActions, model };
