"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var lyria_exports = {};
__export(lyria_exports, {
  LyriaConfigSchema: () => LyriaConfigSchema,
  TEST_ONLY: () => TEST_ONLY,
  defineKnownModels: () => defineKnownModels,
  defineModel: () => defineModel,
  isLyriaModelName: () => isLyriaModelName,
  listActions: () => listActions,
  model: () => model
});
module.exports = __toCommonJS(lyria_exports);
var import_genkit = require("genkit");
var import_client = require("./client.js");
var import_converters = require("./converters.js");
var import_utils = require("./utils.js");
const LyriaConfigSchema = import_genkit.z.object({
  negativePrompt: import_genkit.z.string().optional().describe(
    "Optional. A description of what to exclude from the generated audio."
  ),
  seed: import_genkit.z.number().optional().describe(
    "Optional. A seed for deterministic generation. If provided, the model will attempt to produce the same audio given the same prompt and other parameters. Cannot be used with sample_count in the same request."
  ),
  sampleCount: import_genkit.z.number().optional().describe(
    "Optional. The number of audio samples to generate. Default is 1 if not specified and seed is not used. Cannot be used with seed in the same request."
  )
}).passthrough();
function commonRef(name, info, configSchema = LyriaConfigSchema) {
  return (0, import_genkit.modelRef)({
    name: `vertexai/${name}`,
    configSchema,
    info: info ?? {
      supports: {
        media: true,
        multiturn: false,
        tools: false,
        systemRole: false,
        output: ["media"]
      }
    }
  });
}
const GENERIC_MODEL = commonRef("lyria");
const KNOWN_MODELS = {
  "lyria-002": commonRef("lyria-002")
};
function isLyriaModelName(value) {
  return !!value?.startsWith("lyria-");
}
function model(version, config = {}) {
  const name = (0, import_utils.checkModelName)(version);
  return (0, import_genkit.modelRef)({
    name: `vertexai/${name}`,
    config,
    configSchema: LyriaConfigSchema,
    info: { ...GENERIC_MODEL.info }
  });
}
function listActions(models) {
  return models.filter((m) => isLyriaModelName(m.name)).map((m) => {
    const ref = model(m.name);
    return (0, import_genkit.modelActionMetadata)({
      name: ref.name,
      info: ref.info,
      configSchema: ref.configSchema
    });
  });
}
function defineKnownModels(ai, clientOptions, pluginOptions) {
  for (const name of Object.keys(KNOWN_MODELS)) {
    defineModel(ai, name, clientOptions, pluginOptions);
  }
}
function defineModel(ai, name, clientOptions, pluginOptions) {
  const ref = model(name);
  return ai.defineModel(
    {
      apiVersion: "v2",
      name: ref.name,
      ...ref.info,
      configSchema: ref.configSchema
    },
    async (request, { abortSignal }) => {
      const clientOpt = { ...clientOptions, signal: abortSignal };
      const lyriaPredictRequest = (0, import_converters.toLyriaPredictRequest)(request);
      const response = await (0, import_client.lyriaPredict)(
        (0, import_utils.extractVersion)(ref),
        lyriaPredictRequest,
        clientOpt
      );
      if (!response.predictions || response.predictions.length == 0) {
        throw new Error(
          "Model returned no predictions. Possibly due to content filters."
        );
      }
      return (0, import_converters.fromLyriaResponse)(response, request);
    }
  );
}
const TEST_ONLY = {
  GENERIC_MODEL,
  KNOWN_MODELS
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  LyriaConfigSchema,
  TEST_ONLY,
  defineKnownModels,
  defineModel,
  isLyriaModelName,
  listActions,
  model
});
//# sourceMappingURL=lyria.js.map