import { ModelReference, z, ActionMetadata, Genkit } from 'genkit';
import { BackgroundModelAction } from 'genkit/model';
import { Model, ClientOptions, VertexPluginOptions } from './types.js';
import 'google-auth-library';
import '../common/types.js';

/**
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

declare const VeoConfigSchema: z.ZodObject<{
    sampleCount: z.ZodOptional<z.ZodNumber>;
    storageUri: z.ZodOptional<z.ZodString>;
    fps: z.ZodOptional<z.ZodNumber>;
    durationSeconds: z.ZodOptional<z.ZodNumber>;
    seed: z.ZodOptional<z.ZodNumber>;
    aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
    resolution: z.ZodOptional<z.ZodEnum<["720p", "1080p"]>>;
    personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
    pubsubTopic: z.ZodOptional<z.ZodString>;
    negativePrompt: z.ZodOptional<z.ZodString>;
    enhancePrompt: z.ZodOptional<z.ZodBoolean>;
    generateAudio: z.ZodOptional<z.ZodBoolean>;
    compressionQuality: z.ZodOptional<z.ZodDefault<z.ZodEnum<["optimized", "lossless"]>>>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    sampleCount: z.ZodOptional<z.ZodNumber>;
    storageUri: z.ZodOptional<z.ZodString>;
    fps: z.ZodOptional<z.ZodNumber>;
    durationSeconds: z.ZodOptional<z.ZodNumber>;
    seed: z.ZodOptional<z.ZodNumber>;
    aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
    resolution: z.ZodOptional<z.ZodEnum<["720p", "1080p"]>>;
    personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
    pubsubTopic: z.ZodOptional<z.ZodString>;
    negativePrompt: z.ZodOptional<z.ZodString>;
    enhancePrompt: z.ZodOptional<z.ZodBoolean>;
    generateAudio: z.ZodOptional<z.ZodBoolean>;
    compressionQuality: z.ZodOptional<z.ZodDefault<z.ZodEnum<["optimized", "lossless"]>>>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    sampleCount: z.ZodOptional<z.ZodNumber>;
    storageUri: z.ZodOptional<z.ZodString>;
    fps: z.ZodOptional<z.ZodNumber>;
    durationSeconds: z.ZodOptional<z.ZodNumber>;
    seed: z.ZodOptional<z.ZodNumber>;
    aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
    resolution: z.ZodOptional<z.ZodEnum<["720p", "1080p"]>>;
    personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
    pubsubTopic: z.ZodOptional<z.ZodString>;
    negativePrompt: z.ZodOptional<z.ZodString>;
    enhancePrompt: z.ZodOptional<z.ZodBoolean>;
    generateAudio: z.ZodOptional<z.ZodBoolean>;
    compressionQuality: z.ZodOptional<z.ZodDefault<z.ZodEnum<["optimized", "lossless"]>>>;
}, z.ZodTypeAny, "passthrough">>;
type VeoConfigSchemaType = typeof VeoConfigSchema;
type VeoConfig = z.infer<VeoConfigSchemaType>;
type ConfigSchemaType = VeoConfigSchemaType;
declare const KNOWN_MODELS: {
    readonly 'veo-2.0-generate-001': ModelReference<z.ZodObject<{
        sampleCount: z.ZodOptional<z.ZodNumber>;
        storageUri: z.ZodOptional<z.ZodString>;
        fps: z.ZodOptional<z.ZodNumber>;
        durationSeconds: z.ZodOptional<z.ZodNumber>;
        seed: z.ZodOptional<z.ZodNumber>;
        aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
        resolution: z.ZodOptional<z.ZodEnum<["720p", "1080p"]>>;
        personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
        pubsubTopic: z.ZodOptional<z.ZodString>;
        negativePrompt: z.ZodOptional<z.ZodString>;
        enhancePrompt: z.ZodOptional<z.ZodBoolean>;
        generateAudio: z.ZodOptional<z.ZodBoolean>;
        compressionQuality: z.ZodOptional<z.ZodDefault<z.ZodEnum<["optimized", "lossless"]>>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        sampleCount: z.ZodOptional<z.ZodNumber>;
        storageUri: z.ZodOptional<z.ZodString>;
        fps: z.ZodOptional<z.ZodNumber>;
        durationSeconds: z.ZodOptional<z.ZodNumber>;
        seed: z.ZodOptional<z.ZodNumber>;
        aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
        resolution: z.ZodOptional<z.ZodEnum<["720p", "1080p"]>>;
        personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
        pubsubTopic: z.ZodOptional<z.ZodString>;
        negativePrompt: z.ZodOptional<z.ZodString>;
        enhancePrompt: z.ZodOptional<z.ZodBoolean>;
        generateAudio: z.ZodOptional<z.ZodBoolean>;
        compressionQuality: z.ZodOptional<z.ZodDefault<z.ZodEnum<["optimized", "lossless"]>>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        sampleCount: z.ZodOptional<z.ZodNumber>;
        storageUri: z.ZodOptional<z.ZodString>;
        fps: z.ZodOptional<z.ZodNumber>;
        durationSeconds: z.ZodOptional<z.ZodNumber>;
        seed: z.ZodOptional<z.ZodNumber>;
        aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
        resolution: z.ZodOptional<z.ZodEnum<["720p", "1080p"]>>;
        personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
        pubsubTopic: z.ZodOptional<z.ZodString>;
        negativePrompt: z.ZodOptional<z.ZodString>;
        enhancePrompt: z.ZodOptional<z.ZodBoolean>;
        generateAudio: z.ZodOptional<z.ZodBoolean>;
        compressionQuality: z.ZodOptional<z.ZodDefault<z.ZodEnum<["optimized", "lossless"]>>>;
    }, z.ZodTypeAny, "passthrough">>>;
    readonly 'veo-3.0-generate-001': ModelReference<z.ZodObject<{
        sampleCount: z.ZodOptional<z.ZodNumber>;
        storageUri: z.ZodOptional<z.ZodString>;
        fps: z.ZodOptional<z.ZodNumber>;
        durationSeconds: z.ZodOptional<z.ZodNumber>;
        seed: z.ZodOptional<z.ZodNumber>;
        aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
        resolution: z.ZodOptional<z.ZodEnum<["720p", "1080p"]>>;
        personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
        pubsubTopic: z.ZodOptional<z.ZodString>;
        negativePrompt: z.ZodOptional<z.ZodString>;
        enhancePrompt: z.ZodOptional<z.ZodBoolean>;
        generateAudio: z.ZodOptional<z.ZodBoolean>;
        compressionQuality: z.ZodOptional<z.ZodDefault<z.ZodEnum<["optimized", "lossless"]>>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        sampleCount: z.ZodOptional<z.ZodNumber>;
        storageUri: z.ZodOptional<z.ZodString>;
        fps: z.ZodOptional<z.ZodNumber>;
        durationSeconds: z.ZodOptional<z.ZodNumber>;
        seed: z.ZodOptional<z.ZodNumber>;
        aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
        resolution: z.ZodOptional<z.ZodEnum<["720p", "1080p"]>>;
        personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
        pubsubTopic: z.ZodOptional<z.ZodString>;
        negativePrompt: z.ZodOptional<z.ZodString>;
        enhancePrompt: z.ZodOptional<z.ZodBoolean>;
        generateAudio: z.ZodOptional<z.ZodBoolean>;
        compressionQuality: z.ZodOptional<z.ZodDefault<z.ZodEnum<["optimized", "lossless"]>>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        sampleCount: z.ZodOptional<z.ZodNumber>;
        storageUri: z.ZodOptional<z.ZodString>;
        fps: z.ZodOptional<z.ZodNumber>;
        durationSeconds: z.ZodOptional<z.ZodNumber>;
        seed: z.ZodOptional<z.ZodNumber>;
        aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
        resolution: z.ZodOptional<z.ZodEnum<["720p", "1080p"]>>;
        personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
        pubsubTopic: z.ZodOptional<z.ZodString>;
        negativePrompt: z.ZodOptional<z.ZodString>;
        enhancePrompt: z.ZodOptional<z.ZodBoolean>;
        generateAudio: z.ZodOptional<z.ZodBoolean>;
        compressionQuality: z.ZodOptional<z.ZodDefault<z.ZodEnum<["optimized", "lossless"]>>>;
    }, z.ZodTypeAny, "passthrough">>>;
    readonly 'veo-3.0-fast-generate-001': ModelReference<z.ZodObject<{
        sampleCount: z.ZodOptional<z.ZodNumber>;
        storageUri: z.ZodOptional<z.ZodString>;
        fps: z.ZodOptional<z.ZodNumber>;
        durationSeconds: z.ZodOptional<z.ZodNumber>;
        seed: z.ZodOptional<z.ZodNumber>;
        aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
        resolution: z.ZodOptional<z.ZodEnum<["720p", "1080p"]>>;
        personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
        pubsubTopic: z.ZodOptional<z.ZodString>;
        negativePrompt: z.ZodOptional<z.ZodString>;
        enhancePrompt: z.ZodOptional<z.ZodBoolean>;
        generateAudio: z.ZodOptional<z.ZodBoolean>;
        compressionQuality: z.ZodOptional<z.ZodDefault<z.ZodEnum<["optimized", "lossless"]>>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        sampleCount: z.ZodOptional<z.ZodNumber>;
        storageUri: z.ZodOptional<z.ZodString>;
        fps: z.ZodOptional<z.ZodNumber>;
        durationSeconds: z.ZodOptional<z.ZodNumber>;
        seed: z.ZodOptional<z.ZodNumber>;
        aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
        resolution: z.ZodOptional<z.ZodEnum<["720p", "1080p"]>>;
        personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
        pubsubTopic: z.ZodOptional<z.ZodString>;
        negativePrompt: z.ZodOptional<z.ZodString>;
        enhancePrompt: z.ZodOptional<z.ZodBoolean>;
        generateAudio: z.ZodOptional<z.ZodBoolean>;
        compressionQuality: z.ZodOptional<z.ZodDefault<z.ZodEnum<["optimized", "lossless"]>>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        sampleCount: z.ZodOptional<z.ZodNumber>;
        storageUri: z.ZodOptional<z.ZodString>;
        fps: z.ZodOptional<z.ZodNumber>;
        durationSeconds: z.ZodOptional<z.ZodNumber>;
        seed: z.ZodOptional<z.ZodNumber>;
        aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
        resolution: z.ZodOptional<z.ZodEnum<["720p", "1080p"]>>;
        personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
        pubsubTopic: z.ZodOptional<z.ZodString>;
        negativePrompt: z.ZodOptional<z.ZodString>;
        enhancePrompt: z.ZodOptional<z.ZodBoolean>;
        generateAudio: z.ZodOptional<z.ZodBoolean>;
        compressionQuality: z.ZodOptional<z.ZodDefault<z.ZodEnum<["optimized", "lossless"]>>>;
    }, z.ZodTypeAny, "passthrough">>>;
    readonly 'veo-3.0-generate-preview': ModelReference<z.ZodObject<{
        sampleCount: z.ZodOptional<z.ZodNumber>;
        storageUri: z.ZodOptional<z.ZodString>;
        fps: z.ZodOptional<z.ZodNumber>;
        durationSeconds: z.ZodOptional<z.ZodNumber>;
        seed: z.ZodOptional<z.ZodNumber>;
        aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
        resolution: z.ZodOptional<z.ZodEnum<["720p", "1080p"]>>;
        personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
        pubsubTopic: z.ZodOptional<z.ZodString>;
        negativePrompt: z.ZodOptional<z.ZodString>;
        enhancePrompt: z.ZodOptional<z.ZodBoolean>;
        generateAudio: z.ZodOptional<z.ZodBoolean>;
        compressionQuality: z.ZodOptional<z.ZodDefault<z.ZodEnum<["optimized", "lossless"]>>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        sampleCount: z.ZodOptional<z.ZodNumber>;
        storageUri: z.ZodOptional<z.ZodString>;
        fps: z.ZodOptional<z.ZodNumber>;
        durationSeconds: z.ZodOptional<z.ZodNumber>;
        seed: z.ZodOptional<z.ZodNumber>;
        aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
        resolution: z.ZodOptional<z.ZodEnum<["720p", "1080p"]>>;
        personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
        pubsubTopic: z.ZodOptional<z.ZodString>;
        negativePrompt: z.ZodOptional<z.ZodString>;
        enhancePrompt: z.ZodOptional<z.ZodBoolean>;
        generateAudio: z.ZodOptional<z.ZodBoolean>;
        compressionQuality: z.ZodOptional<z.ZodDefault<z.ZodEnum<["optimized", "lossless"]>>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        sampleCount: z.ZodOptional<z.ZodNumber>;
        storageUri: z.ZodOptional<z.ZodString>;
        fps: z.ZodOptional<z.ZodNumber>;
        durationSeconds: z.ZodOptional<z.ZodNumber>;
        seed: z.ZodOptional<z.ZodNumber>;
        aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
        resolution: z.ZodOptional<z.ZodEnum<["720p", "1080p"]>>;
        personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
        pubsubTopic: z.ZodOptional<z.ZodString>;
        negativePrompt: z.ZodOptional<z.ZodString>;
        enhancePrompt: z.ZodOptional<z.ZodBoolean>;
        generateAudio: z.ZodOptional<z.ZodBoolean>;
        compressionQuality: z.ZodOptional<z.ZodDefault<z.ZodEnum<["optimized", "lossless"]>>>;
    }, z.ZodTypeAny, "passthrough">>>;
    readonly 'veo-3.0-fast-generate-preview': ModelReference<z.ZodObject<{
        sampleCount: z.ZodOptional<z.ZodNumber>;
        storageUri: z.ZodOptional<z.ZodString>;
        fps: z.ZodOptional<z.ZodNumber>;
        durationSeconds: z.ZodOptional<z.ZodNumber>;
        seed: z.ZodOptional<z.ZodNumber>;
        aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
        resolution: z.ZodOptional<z.ZodEnum<["720p", "1080p"]>>;
        personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
        pubsubTopic: z.ZodOptional<z.ZodString>;
        negativePrompt: z.ZodOptional<z.ZodString>;
        enhancePrompt: z.ZodOptional<z.ZodBoolean>;
        generateAudio: z.ZodOptional<z.ZodBoolean>;
        compressionQuality: z.ZodOptional<z.ZodDefault<z.ZodEnum<["optimized", "lossless"]>>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        sampleCount: z.ZodOptional<z.ZodNumber>;
        storageUri: z.ZodOptional<z.ZodString>;
        fps: z.ZodOptional<z.ZodNumber>;
        durationSeconds: z.ZodOptional<z.ZodNumber>;
        seed: z.ZodOptional<z.ZodNumber>;
        aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
        resolution: z.ZodOptional<z.ZodEnum<["720p", "1080p"]>>;
        personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
        pubsubTopic: z.ZodOptional<z.ZodString>;
        negativePrompt: z.ZodOptional<z.ZodString>;
        enhancePrompt: z.ZodOptional<z.ZodBoolean>;
        generateAudio: z.ZodOptional<z.ZodBoolean>;
        compressionQuality: z.ZodOptional<z.ZodDefault<z.ZodEnum<["optimized", "lossless"]>>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        sampleCount: z.ZodOptional<z.ZodNumber>;
        storageUri: z.ZodOptional<z.ZodString>;
        fps: z.ZodOptional<z.ZodNumber>;
        durationSeconds: z.ZodOptional<z.ZodNumber>;
        seed: z.ZodOptional<z.ZodNumber>;
        aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
        resolution: z.ZodOptional<z.ZodEnum<["720p", "1080p"]>>;
        personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
        pubsubTopic: z.ZodOptional<z.ZodString>;
        negativePrompt: z.ZodOptional<z.ZodString>;
        enhancePrompt: z.ZodOptional<z.ZodBoolean>;
        generateAudio: z.ZodOptional<z.ZodBoolean>;
        compressionQuality: z.ZodOptional<z.ZodDefault<z.ZodEnum<["optimized", "lossless"]>>>;
    }, z.ZodTypeAny, "passthrough">>>;
};
type KnownModels = keyof typeof KNOWN_MODELS;
type VeoModelName = `veo-${string}`;
declare function isVeoModelName(value?: string): value is VeoModelName;
declare function model(version: string, config?: VeoConfig): ModelReference<ConfigSchemaType>;
declare function listActions(models: Model[]): ActionMetadata[];
declare function defineKnownModels(ai: Genkit, clientOptions: ClientOptions, pluginOptions?: VertexPluginOptions): void;
declare function defineModel(ai: Genkit, name: string, clientOptions: ClientOptions, pluginOptions?: VertexPluginOptions): BackgroundModelAction<VeoConfigSchemaType>;
declare const TEST_ONLY: {
    GENERIC_MODEL: ModelReference<z.ZodObject<{
        sampleCount: z.ZodOptional<z.ZodNumber>;
        storageUri: z.ZodOptional<z.ZodString>;
        fps: z.ZodOptional<z.ZodNumber>;
        durationSeconds: z.ZodOptional<z.ZodNumber>;
        seed: z.ZodOptional<z.ZodNumber>;
        aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
        resolution: z.ZodOptional<z.ZodEnum<["720p", "1080p"]>>;
        personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
        pubsubTopic: z.ZodOptional<z.ZodString>;
        negativePrompt: z.ZodOptional<z.ZodString>;
        enhancePrompt: z.ZodOptional<z.ZodBoolean>;
        generateAudio: z.ZodOptional<z.ZodBoolean>;
        compressionQuality: z.ZodOptional<z.ZodDefault<z.ZodEnum<["optimized", "lossless"]>>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        sampleCount: z.ZodOptional<z.ZodNumber>;
        storageUri: z.ZodOptional<z.ZodString>;
        fps: z.ZodOptional<z.ZodNumber>;
        durationSeconds: z.ZodOptional<z.ZodNumber>;
        seed: z.ZodOptional<z.ZodNumber>;
        aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
        resolution: z.ZodOptional<z.ZodEnum<["720p", "1080p"]>>;
        personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
        pubsubTopic: z.ZodOptional<z.ZodString>;
        negativePrompt: z.ZodOptional<z.ZodString>;
        enhancePrompt: z.ZodOptional<z.ZodBoolean>;
        generateAudio: z.ZodOptional<z.ZodBoolean>;
        compressionQuality: z.ZodOptional<z.ZodDefault<z.ZodEnum<["optimized", "lossless"]>>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        sampleCount: z.ZodOptional<z.ZodNumber>;
        storageUri: z.ZodOptional<z.ZodString>;
        fps: z.ZodOptional<z.ZodNumber>;
        durationSeconds: z.ZodOptional<z.ZodNumber>;
        seed: z.ZodOptional<z.ZodNumber>;
        aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
        resolution: z.ZodOptional<z.ZodEnum<["720p", "1080p"]>>;
        personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
        pubsubTopic: z.ZodOptional<z.ZodString>;
        negativePrompt: z.ZodOptional<z.ZodString>;
        enhancePrompt: z.ZodOptional<z.ZodBoolean>;
        generateAudio: z.ZodOptional<z.ZodBoolean>;
        compressionQuality: z.ZodOptional<z.ZodDefault<z.ZodEnum<["optimized", "lossless"]>>>;
    }, z.ZodTypeAny, "passthrough">>>;
    KNOWN_MODELS: {
        readonly 'veo-2.0-generate-001': ModelReference<z.ZodObject<{
            sampleCount: z.ZodOptional<z.ZodNumber>;
            storageUri: z.ZodOptional<z.ZodString>;
            fps: z.ZodOptional<z.ZodNumber>;
            durationSeconds: z.ZodOptional<z.ZodNumber>;
            seed: z.ZodOptional<z.ZodNumber>;
            aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
            resolution: z.ZodOptional<z.ZodEnum<["720p", "1080p"]>>;
            personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
            pubsubTopic: z.ZodOptional<z.ZodString>;
            negativePrompt: z.ZodOptional<z.ZodString>;
            enhancePrompt: z.ZodOptional<z.ZodBoolean>;
            generateAudio: z.ZodOptional<z.ZodBoolean>;
            compressionQuality: z.ZodOptional<z.ZodDefault<z.ZodEnum<["optimized", "lossless"]>>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            sampleCount: z.ZodOptional<z.ZodNumber>;
            storageUri: z.ZodOptional<z.ZodString>;
            fps: z.ZodOptional<z.ZodNumber>;
            durationSeconds: z.ZodOptional<z.ZodNumber>;
            seed: z.ZodOptional<z.ZodNumber>;
            aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
            resolution: z.ZodOptional<z.ZodEnum<["720p", "1080p"]>>;
            personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
            pubsubTopic: z.ZodOptional<z.ZodString>;
            negativePrompt: z.ZodOptional<z.ZodString>;
            enhancePrompt: z.ZodOptional<z.ZodBoolean>;
            generateAudio: z.ZodOptional<z.ZodBoolean>;
            compressionQuality: z.ZodOptional<z.ZodDefault<z.ZodEnum<["optimized", "lossless"]>>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            sampleCount: z.ZodOptional<z.ZodNumber>;
            storageUri: z.ZodOptional<z.ZodString>;
            fps: z.ZodOptional<z.ZodNumber>;
            durationSeconds: z.ZodOptional<z.ZodNumber>;
            seed: z.ZodOptional<z.ZodNumber>;
            aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
            resolution: z.ZodOptional<z.ZodEnum<["720p", "1080p"]>>;
            personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
            pubsubTopic: z.ZodOptional<z.ZodString>;
            negativePrompt: z.ZodOptional<z.ZodString>;
            enhancePrompt: z.ZodOptional<z.ZodBoolean>;
            generateAudio: z.ZodOptional<z.ZodBoolean>;
            compressionQuality: z.ZodOptional<z.ZodDefault<z.ZodEnum<["optimized", "lossless"]>>>;
        }, z.ZodTypeAny, "passthrough">>>;
        readonly 'veo-3.0-generate-001': ModelReference<z.ZodObject<{
            sampleCount: z.ZodOptional<z.ZodNumber>;
            storageUri: z.ZodOptional<z.ZodString>;
            fps: z.ZodOptional<z.ZodNumber>;
            durationSeconds: z.ZodOptional<z.ZodNumber>;
            seed: z.ZodOptional<z.ZodNumber>;
            aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
            resolution: z.ZodOptional<z.ZodEnum<["720p", "1080p"]>>;
            personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
            pubsubTopic: z.ZodOptional<z.ZodString>;
            negativePrompt: z.ZodOptional<z.ZodString>;
            enhancePrompt: z.ZodOptional<z.ZodBoolean>;
            generateAudio: z.ZodOptional<z.ZodBoolean>;
            compressionQuality: z.ZodOptional<z.ZodDefault<z.ZodEnum<["optimized", "lossless"]>>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            sampleCount: z.ZodOptional<z.ZodNumber>;
            storageUri: z.ZodOptional<z.ZodString>;
            fps: z.ZodOptional<z.ZodNumber>;
            durationSeconds: z.ZodOptional<z.ZodNumber>;
            seed: z.ZodOptional<z.ZodNumber>;
            aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
            resolution: z.ZodOptional<z.ZodEnum<["720p", "1080p"]>>;
            personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
            pubsubTopic: z.ZodOptional<z.ZodString>;
            negativePrompt: z.ZodOptional<z.ZodString>;
            enhancePrompt: z.ZodOptional<z.ZodBoolean>;
            generateAudio: z.ZodOptional<z.ZodBoolean>;
            compressionQuality: z.ZodOptional<z.ZodDefault<z.ZodEnum<["optimized", "lossless"]>>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            sampleCount: z.ZodOptional<z.ZodNumber>;
            storageUri: z.ZodOptional<z.ZodString>;
            fps: z.ZodOptional<z.ZodNumber>;
            durationSeconds: z.ZodOptional<z.ZodNumber>;
            seed: z.ZodOptional<z.ZodNumber>;
            aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
            resolution: z.ZodOptional<z.ZodEnum<["720p", "1080p"]>>;
            personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
            pubsubTopic: z.ZodOptional<z.ZodString>;
            negativePrompt: z.ZodOptional<z.ZodString>;
            enhancePrompt: z.ZodOptional<z.ZodBoolean>;
            generateAudio: z.ZodOptional<z.ZodBoolean>;
            compressionQuality: z.ZodOptional<z.ZodDefault<z.ZodEnum<["optimized", "lossless"]>>>;
        }, z.ZodTypeAny, "passthrough">>>;
        readonly 'veo-3.0-fast-generate-001': ModelReference<z.ZodObject<{
            sampleCount: z.ZodOptional<z.ZodNumber>;
            storageUri: z.ZodOptional<z.ZodString>;
            fps: z.ZodOptional<z.ZodNumber>;
            durationSeconds: z.ZodOptional<z.ZodNumber>;
            seed: z.ZodOptional<z.ZodNumber>;
            aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
            resolution: z.ZodOptional<z.ZodEnum<["720p", "1080p"]>>;
            personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
            pubsubTopic: z.ZodOptional<z.ZodString>;
            negativePrompt: z.ZodOptional<z.ZodString>;
            enhancePrompt: z.ZodOptional<z.ZodBoolean>;
            generateAudio: z.ZodOptional<z.ZodBoolean>;
            compressionQuality: z.ZodOptional<z.ZodDefault<z.ZodEnum<["optimized", "lossless"]>>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            sampleCount: z.ZodOptional<z.ZodNumber>;
            storageUri: z.ZodOptional<z.ZodString>;
            fps: z.ZodOptional<z.ZodNumber>;
            durationSeconds: z.ZodOptional<z.ZodNumber>;
            seed: z.ZodOptional<z.ZodNumber>;
            aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
            resolution: z.ZodOptional<z.ZodEnum<["720p", "1080p"]>>;
            personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
            pubsubTopic: z.ZodOptional<z.ZodString>;
            negativePrompt: z.ZodOptional<z.ZodString>;
            enhancePrompt: z.ZodOptional<z.ZodBoolean>;
            generateAudio: z.ZodOptional<z.ZodBoolean>;
            compressionQuality: z.ZodOptional<z.ZodDefault<z.ZodEnum<["optimized", "lossless"]>>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            sampleCount: z.ZodOptional<z.ZodNumber>;
            storageUri: z.ZodOptional<z.ZodString>;
            fps: z.ZodOptional<z.ZodNumber>;
            durationSeconds: z.ZodOptional<z.ZodNumber>;
            seed: z.ZodOptional<z.ZodNumber>;
            aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
            resolution: z.ZodOptional<z.ZodEnum<["720p", "1080p"]>>;
            personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
            pubsubTopic: z.ZodOptional<z.ZodString>;
            negativePrompt: z.ZodOptional<z.ZodString>;
            enhancePrompt: z.ZodOptional<z.ZodBoolean>;
            generateAudio: z.ZodOptional<z.ZodBoolean>;
            compressionQuality: z.ZodOptional<z.ZodDefault<z.ZodEnum<["optimized", "lossless"]>>>;
        }, z.ZodTypeAny, "passthrough">>>;
        readonly 'veo-3.0-generate-preview': ModelReference<z.ZodObject<{
            sampleCount: z.ZodOptional<z.ZodNumber>;
            storageUri: z.ZodOptional<z.ZodString>;
            fps: z.ZodOptional<z.ZodNumber>;
            durationSeconds: z.ZodOptional<z.ZodNumber>;
            seed: z.ZodOptional<z.ZodNumber>;
            aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
            resolution: z.ZodOptional<z.ZodEnum<["720p", "1080p"]>>;
            personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
            pubsubTopic: z.ZodOptional<z.ZodString>;
            negativePrompt: z.ZodOptional<z.ZodString>;
            enhancePrompt: z.ZodOptional<z.ZodBoolean>;
            generateAudio: z.ZodOptional<z.ZodBoolean>;
            compressionQuality: z.ZodOptional<z.ZodDefault<z.ZodEnum<["optimized", "lossless"]>>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            sampleCount: z.ZodOptional<z.ZodNumber>;
            storageUri: z.ZodOptional<z.ZodString>;
            fps: z.ZodOptional<z.ZodNumber>;
            durationSeconds: z.ZodOptional<z.ZodNumber>;
            seed: z.ZodOptional<z.ZodNumber>;
            aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
            resolution: z.ZodOptional<z.ZodEnum<["720p", "1080p"]>>;
            personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
            pubsubTopic: z.ZodOptional<z.ZodString>;
            negativePrompt: z.ZodOptional<z.ZodString>;
            enhancePrompt: z.ZodOptional<z.ZodBoolean>;
            generateAudio: z.ZodOptional<z.ZodBoolean>;
            compressionQuality: z.ZodOptional<z.ZodDefault<z.ZodEnum<["optimized", "lossless"]>>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            sampleCount: z.ZodOptional<z.ZodNumber>;
            storageUri: z.ZodOptional<z.ZodString>;
            fps: z.ZodOptional<z.ZodNumber>;
            durationSeconds: z.ZodOptional<z.ZodNumber>;
            seed: z.ZodOptional<z.ZodNumber>;
            aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
            resolution: z.ZodOptional<z.ZodEnum<["720p", "1080p"]>>;
            personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
            pubsubTopic: z.ZodOptional<z.ZodString>;
            negativePrompt: z.ZodOptional<z.ZodString>;
            enhancePrompt: z.ZodOptional<z.ZodBoolean>;
            generateAudio: z.ZodOptional<z.ZodBoolean>;
            compressionQuality: z.ZodOptional<z.ZodDefault<z.ZodEnum<["optimized", "lossless"]>>>;
        }, z.ZodTypeAny, "passthrough">>>;
        readonly 'veo-3.0-fast-generate-preview': ModelReference<z.ZodObject<{
            sampleCount: z.ZodOptional<z.ZodNumber>;
            storageUri: z.ZodOptional<z.ZodString>;
            fps: z.ZodOptional<z.ZodNumber>;
            durationSeconds: z.ZodOptional<z.ZodNumber>;
            seed: z.ZodOptional<z.ZodNumber>;
            aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
            resolution: z.ZodOptional<z.ZodEnum<["720p", "1080p"]>>;
            personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
            pubsubTopic: z.ZodOptional<z.ZodString>;
            negativePrompt: z.ZodOptional<z.ZodString>;
            enhancePrompt: z.ZodOptional<z.ZodBoolean>;
            generateAudio: z.ZodOptional<z.ZodBoolean>;
            compressionQuality: z.ZodOptional<z.ZodDefault<z.ZodEnum<["optimized", "lossless"]>>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            sampleCount: z.ZodOptional<z.ZodNumber>;
            storageUri: z.ZodOptional<z.ZodString>;
            fps: z.ZodOptional<z.ZodNumber>;
            durationSeconds: z.ZodOptional<z.ZodNumber>;
            seed: z.ZodOptional<z.ZodNumber>;
            aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
            resolution: z.ZodOptional<z.ZodEnum<["720p", "1080p"]>>;
            personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
            pubsubTopic: z.ZodOptional<z.ZodString>;
            negativePrompt: z.ZodOptional<z.ZodString>;
            enhancePrompt: z.ZodOptional<z.ZodBoolean>;
            generateAudio: z.ZodOptional<z.ZodBoolean>;
            compressionQuality: z.ZodOptional<z.ZodDefault<z.ZodEnum<["optimized", "lossless"]>>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            sampleCount: z.ZodOptional<z.ZodNumber>;
            storageUri: z.ZodOptional<z.ZodString>;
            fps: z.ZodOptional<z.ZodNumber>;
            durationSeconds: z.ZodOptional<z.ZodNumber>;
            seed: z.ZodOptional<z.ZodNumber>;
            aspectRatio: z.ZodOptional<z.ZodEnum<["9:16", "16:9"]>>;
            resolution: z.ZodOptional<z.ZodEnum<["720p", "1080p"]>>;
            personGeneration: z.ZodOptional<z.ZodEnum<["dont_allow", "allow_adult", "allow_all"]>>;
            pubsubTopic: z.ZodOptional<z.ZodString>;
            negativePrompt: z.ZodOptional<z.ZodString>;
            enhancePrompt: z.ZodOptional<z.ZodBoolean>;
            generateAudio: z.ZodOptional<z.ZodBoolean>;
            compressionQuality: z.ZodOptional<z.ZodDefault<z.ZodEnum<["optimized", "lossless"]>>>;
        }, z.ZodTypeAny, "passthrough">>>;
    };
};

export { type KnownModels, TEST_ONLY, type VeoConfig, VeoConfigSchema, type VeoConfigSchemaType, type VeoModelName, defineKnownModels, defineModel, isVeoModelName, listActions, model };
