import { Button } from "@/components/ui/button";
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card";
import { Input } from "@/components/ui/input";
import { Label } from "@/components/ui/label";
import { Textarea } from "@/components/ui/textarea";
import { Mail, Phone, MapPin } from "lucide-react";

export default function ContactPage() {
  const contact = {
    address: "Pharmamitra, G-10D, Smartworld Orchard, Sector 61, Gurugram - 122102",
    email: "care@pharmamitra.com",
    phone: "+91-8003467285",
  };
    
  return (
    <div className="bg-background">
      <header className="bg-primary text-primary-foreground py-16">
        <div className="container text-center">
          <h1 className="font-headline text-4xl md:text-5xl font-bold">Contact Us</h1>
          <p className="mt-4 text-lg max-w-3xl mx-auto text-primary-foreground/80">
            We're here to help. Reach out to us with any questions or inquiries.
          </p>
        </div>
      </header>

      <section className="py-16 container">
        <div className="grid md:grid-cols-2 gap-12">
            <div>
                <h2 className="font-headline text-3xl font-bold text-primary">Get in Touch</h2>
                <p className="mt-4 text-lg text-muted-foreground">
                    Fill out the form and our team will get back to you within 24 hours.
                </p>
                <div className="mt-8 space-y-6">
                    <div className="flex items-center gap-4">
                        <Phone className="h-6 w-6 text-accent"/>
                        <a href={`tel:${contact.phone}`} className="text-lg text-foreground hover:text-primary">{contact.phone}</a>
                    </div>
                     <div className="flex items-center gap-4">
                        <Mail className="h-6 w-6 text-accent"/>
                        <a href={`mailto:${contact.email}`} className="text-lg text-foreground hover:text-primary">{contact.email}</a>
                    </div>
                     <div className="flex items-start gap-4">
                        <MapPin className="h-6 w-6 text-accent mt-1"/>
                        <p className="text-lg text-foreground">{contact.address}</p>
                    </div>
                </div>
            </div>
            <Card className="shadow-lg">
                <CardHeader>
                    <CardTitle className="font-headline">Send us a Message</CardTitle>
                </CardHeader>
                <CardContent>
                    <form className="space-y-4">
                        <div className="grid grid-cols-1 sm:grid-cols-2 gap-4">
                            <div className="space-y-2">
                                <Label htmlFor="first-name">First Name</Label>
                                <Input id="first-name" placeholder="John" />
                            </div>
                            <div className="space-y-2">
                                <Label htmlFor="last-name">Last Name</Label>
                                <Input id="last-name" placeholder="Doe" />
                            </div>
                        </div>
                        <div className="space-y-2">
                            <Label htmlFor="email">Email</Label>
                            <Input id="email" type="email" placeholder="john.doe@example.com" />
                        </div>
                        <div className="space-y-2">
                            <Label htmlFor="message">Message</Label>
                            <Textarea id="message" placeholder="Your message..." />
                        </div>
                        <Button type="submit" className="w-full">Send Message</Button>
                    </form>
                </CardContent>
            </Card>
        </div>
      </section>
    </div>
  );
}
