import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card";

export default function JobsPage() {
  return (
    <div className="bg-background">
      <header className="bg-primary text-primary-foreground py-16">
        <div className="container text-center">
          <h1 className="font-headline text-4xl md:text-5xl font-bold">Job Opportunities</h1>
          <p className="mt-4 text-lg max-w-3xl mx-auto text-primary-foreground/80">
            Find your next career move in the pharmaceutical industry.
          </p>
        </div>
      </header>
      <div className="container py-12">
        <Card className="text-center">
            <CardHeader>
                <CardTitle>Search Results</CardTitle>
                <CardDescription>Job listings based on your search criteria will appear here.</CardDescription>
            </CardHeader>
            <CardContent>
                <p className="text-muted-foreground">No jobs found matching your search. Try different criteria.</p>
            </CardContent>
        </Card>
      </div>
    </div>
  );
}
