import { Button } from "@/components/ui/button";
import { Select, SelectContent, SelectItem, SelectTrigger, SelectValue } from "@/components/ui/select";
import { cities } from "@/lib/data";
import { Search } from "lucide-react";
import Link from "next/link";

export function HeroSection() {
  return (
    <section className="relative bg-primary text-primary-foreground py-24 md:py-32">
      <div
        className="absolute inset-0 bg-cover bg-center opacity-10"
        style={{ backgroundImage: "url('https://www.transparenttextures.com/patterns/cubes.png')" }}
      ></div>
      <div className="container relative z-10 text-center">
        <h1 className="font-headline text-4xl md:text-6xl font-bold tracking-tight">
          Find Trusted Medicine Distributors in Your City
        </h1>
        <p className="mt-4 max-w-2xl mx-auto text-lg md:text-xl text-primary-foreground/80">
          Fast, easy, and reliable connections for your pharmaceutical needs.
        </p>
        <div className="mt-8 max-w-xl mx-auto grid grid-cols-1 sm:grid-cols-2 gap-4 items-center sm:bg-background/10 sm:p-2 sm:rounded-lg">
          <Select>
            <SelectTrigger className="h-12 text-md text-foreground">
              <SelectValue placeholder="Select a city" />
            </SelectTrigger>
            <SelectContent>
              {cities.map((city) => (
                <SelectItem key={city} value={city.toLowerCase()}>
                  {city}
                </SelectItem>
              ))}
            </SelectContent>
          </Select>
          <Button size="lg" className="h-12 text-md bg-accent hover:bg-accent/90 text-accent-foreground" asChild>
            <Link href="/distributors">
              <Search className="mr-2 h-5 w-5" />
              Find Medicines
            </Link>
          </Button>
        </div>
      </div>
    </section>
  );
}
