import { Logo } from "@/components/logo";
import Link from "next/link";
import { navLinks } from "@/lib/data";

export function Footer() {
  const contact = {
    address: "Pharmamitra, G-10D, Smartworld Orchard, Sector 61, Gurugram - 122102",
    email: "care@pharmamitra.com",
    phone: "+91-8003467285",
  };

  const organizationSchema = {
    "@context": "https://schema.org",
    "@type": "Organization",
    "name": "PharmaConnect",
    "url": "https://www.pharmaconnect.com",
    "logo": "https://www.pharmaconnect.com/logo.png",
    "contactPoint": {
      "@type": "ContactPoint",
      "telephone": contact.phone,
      "contactType": "customer service",
      "email": contact.email,
    },
    "address": {
      "@type": "PostalAddress",
      "streetAddress": "G-10D, Smartworld Orchard, Sector 61",
      "addressLocality": "Gurugram",
      "postalCode": "122102",
      "addressCountry": "IN"
    }
  };

  return (
    <footer className="bg-background border-t">
      <div className="container py-12 px-4 sm:px-6 lg:px-8">
        <div className="grid grid-cols-1 md:grid-cols-4 gap-8">
          <div className="md:col-span-1">
            <Logo />
            <p className="mt-4 text-muted-foreground text-sm max-w-xs">
              A one-stop platform connecting the entire pharmaceutical ecosystem.
            </p>
          </div>
          <div>
            <h3 className="text-sm font-headline font-semibold tracking-wider uppercase text-foreground">Useful Links</h3>
            <ul className="mt-4 space-y-2">
              {navLinks.filter(l => l.href !== '/').map((link) => (
                <li key={link.href}>
                  <Link href={link.href} className="text-sm text-muted-foreground hover:text-primary transition-colors">
                    {link.label}
                  </Link>
                </li>
              ))}
            </ul>
          </div>
          <div>
            <h3 className="text-sm font-headline font-semibold tracking-wider uppercase text-foreground">Information</h3>
            <address className="mt-4 space-y-2 not-italic text-sm text-muted-foreground">
              <p>{contact.address}</p>
              <p>
                <a href={`mailto:${contact.email}`} className="hover:text-primary transition-colors">
                  {contact.email}
                </a>
              </p>
              <p>
                <a href={`tel:${contact.phone}`} className="hover:text-primary transition-colors">
                  {contact.phone}
                </a>
              </p>
            </address>
          </div>
          <div>
            <h3 className="text-sm font-headline font-semibold tracking-wider uppercase text-foreground">Stay Connected</h3>
             <p className="mt-4 text-sm text-muted-foreground">Follow us on social media for the latest updates.</p>
          </div>
        </div>
        <div className="mt-8 border-t pt-8 text-center text-sm text-muted-foreground">
          <p>&copy; {new Date().getFullYear()} PharmaConnect. All Rights Reserved.</p>
        </div>
      </div>
      <script
        type="application/ld+json"
        dangerouslySetInnerHTML={{ __html: JSON.stringify(organizationSchema) }}
      />
    </footer>
  );
}
