import type { LucideIcon } from "lucide-react";
import { FileText, HeartPulse, RefreshCw, UtensilsCrossed, Building, Briefcase, Users, MapPin, Search } from "lucide-react";

export type Service = {
  title: string;
  slug: string;
  icon: LucideIcon;
  description: string;
};

export const services: Service[] = [
  {
    title: "GST APPLICATION",
    slug: "gst-application",
    icon: FileText,
    description: "Navigate GST registration with our expert assistance.",
  },
  {
    title: "DRUG LIC APPLICATION",
    slug: "drug-license-application",
    icon: HeartPulse,
    description: "Streamline your drug license application process.",
  },
  {
    title: "DRUG LIC RENEWAL",
    slug: "drug-license-renewal",
    icon: RefreshCw,
    description: "Efficiently handle your drug license renewals with us.",
  },
  {
    title: "FOOD LIC APPLICATION",
    slug: "food-license-application",
    icon: UtensilsCrossed,
    description: "Get your food license with our hassle-free process.",
  },
  {
    title: "FOOD LIC RENEWAL",
    slug: "food-license-renewal",
    icon: RefreshCw,
    description: "Quick and easy renewal for your food license.",
  },
];

export const cities: string[] = [
  "Alwar",
  "Jaipur",
  "West Delhi",
  "Gurugram",
  "Mumbai",
  "Bengaluru",
  "Chennai",
  "Hyderabad",
  "Pune",
  "Kolkata",
  "Ahmedabad",
];

export const jobDesignations: string[] = [
  "Pharmacist",
  "Medical Representative",
  "Quality Control Chemist",
  "Regulatory Affairs Officer",
  "Production Manager",
  "Sales Manager",
];

export const experienceLevels: string[] = ["Fresher", "Experienced"];

export const navLinks = [
  { href: "/", label: "Home" },
  { href: "/services", label: "Services" },
  { href: "/about", label: "About Us" },
  { href: "/contact", label: "Contact Us" },
];

export const secondaryNavLinks = [
    { href: "/distributors", label: "As a Distributor" },
    { href: "/manufacturers", label: "As a Manufacturer" },
    { href: "/retailers", label: "As a Retailer" },
]
